package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  PoolId,
  TapeSize,
  KMSKey,
  NumTapesToCreate,
  GatewayARN,
  ClientToken,
  TapeBarcodePrefix
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateTapesRequest(
    gatewayARN: GatewayARN,
    tapeSizeInBytes: TapeSize,
    clientToken: ClientToken,
    numTapesToCreate: NumTapesToCreate,
    tapeBarcodePrefix: TapeBarcodePrefix,
    kmsEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    poolId: Optional[PoolId] = Optional.Absent,
    worm: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.storagegateway.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateTapesRequest = {
    import CreateTapesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateTapesRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .tapeSizeInBytes(TapeSize.unwrap(tapeSizeInBytes): java.lang.Long)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .numTapesToCreate(NumTapesToCreate.unwrap(numTapesToCreate): Integer)
      .tapeBarcodePrefix(
        TapeBarcodePrefix.unwrap(tapeBarcodePrefix): java.lang.String
      )
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        poolId.map(value => PoolId.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(worm.map(value => value: java.lang.Boolean))(_.worm)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CreateTapesRequest.ReadOnly =
    zio.aws.storagegateway.model.CreateTapesRequest.wrap(buildAwsValue())
}
object CreateTapesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateTapesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateTapesRequest =
      zio.aws.storagegateway.model.CreateTapesRequest(
        gatewayARN,
        tapeSizeInBytes,
        clientToken,
        numTapesToCreate,
        tapeBarcodePrefix,
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        poolId.map(value => value),
        worm.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gatewayARN: GatewayARN
    def tapeSizeInBytes: TapeSize
    def clientToken: ClientToken
    def numTapesToCreate: NumTapesToCreate
    def tapeBarcodePrefix: TapeBarcodePrefix
    def kmsEncrypted: Optional[Boolean]
    def kmsKey: Optional[KMSKey]
    def poolId: Optional[PoolId]
    def worm: Optional[Boolean]
    def tags: Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getTapeSizeInBytes: ZIO[Any, Nothing, TapeSize] =
      ZIO.succeed(tapeSizeInBytes)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getNumTapesToCreate: ZIO[Any, Nothing, NumTapesToCreate] =
      ZIO.succeed(numTapesToCreate)
    def getTapeBarcodePrefix: ZIO[Any, Nothing, TapeBarcodePrefix] =
      ZIO.succeed(tapeBarcodePrefix)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getPoolId: ZIO[Any, AwsError, PoolId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getWorm: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("worm", worm)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapesRequest
  ) extends zio.aws.storagegateway.model.CreateTapesRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val tapeSizeInBytes: TapeSize =
      zio.aws.storagegateway.model.primitives.TapeSize(impl.tapeSizeInBytes())
    override val clientToken: ClientToken =
      zio.aws.storagegateway.model.primitives.ClientToken(impl.clientToken())
    override val numTapesToCreate: NumTapesToCreate =
      zio.aws.storagegateway.model.primitives
        .NumTapesToCreate(impl.numTapesToCreate())
    override val tapeBarcodePrefix: TapeBarcodePrefix =
      zio.aws.storagegateway.model.primitives
        .TapeBarcodePrefix(impl.tapeBarcodePrefix())
    override val kmsEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsEncrypted())
      .map(value => value: Boolean)
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val poolId: Optional[PoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value => zio.aws.storagegateway.model.primitives.PoolId(value))
    override val worm: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.worm())
      .map(value => value: Boolean)
    override val tags
        : Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapesRequest
  ): zio.aws.storagegateway.model.CreateTapesRequest.ReadOnly = new Wrapper(
    impl
  )
}
