package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  NetworkInterfaceId,
  VolumeARN,
  DiskId,
  GatewayARN,
  TargetName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachVolumeRequest(
    gatewayARN: GatewayARN,
    targetName: Optional[TargetName] = Optional.Absent,
    volumeARN: VolumeARN,
    networkInterfaceId: NetworkInterfaceId,
    diskId: Optional[DiskId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AttachVolumeRequest = {
    import AttachVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AttachVolumeRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .optionallyWith(
        targetName.map(value => TargetName.unwrap(value): java.lang.String)
      )(_.targetName)
      .volumeARN(VolumeARN.unwrap(volumeARN): java.lang.String)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(
        diskId.map(value => DiskId.unwrap(value): java.lang.String)
      )(_.diskId)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.AttachVolumeRequest.ReadOnly =
    zio.aws.storagegateway.model.AttachVolumeRequest.wrap(buildAwsValue())
}
object AttachVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AttachVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AttachVolumeRequest =
      zio.aws.storagegateway.model.AttachVolumeRequest(
        gatewayARN,
        targetName.map(value => value),
        volumeARN,
        networkInterfaceId,
        diskId.map(value => value)
      )
    def gatewayARN: GatewayARN
    def targetName: Optional[TargetName]
    def volumeARN: VolumeARN
    def networkInterfaceId: NetworkInterfaceId
    def diskId: Optional[DiskId]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getTargetName: ZIO[Any, AwsError, TargetName] =
      AwsError.unwrapOptionField("targetName", targetName)
    def getVolumeARN: ZIO[Any, Nothing, VolumeARN] = ZIO.succeed(volumeARN)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getDiskId: ZIO[Any, AwsError, DiskId] =
      AwsError.unwrapOptionField("diskId", diskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AttachVolumeRequest
  ) extends zio.aws.storagegateway.model.AttachVolumeRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val targetName: Optional[TargetName] = zio.aws.core.internal
      .optionalFromNullable(impl.targetName())
      .map(value => zio.aws.storagegateway.model.primitives.TargetName(value))
    override val volumeARN: VolumeARN =
      zio.aws.storagegateway.model.primitives.VolumeARN(impl.volumeARN())
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.storagegateway.model.primitives
        .NetworkInterfaceId(impl.networkInterfaceId())
    override val diskId: Optional[DiskId] = zio.aws.core.internal
      .optionalFromNullable(impl.diskId())
      .map(value => zio.aws.storagegateway.model.primitives.DiskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AttachVolumeRequest
  ): zio.aws.storagegateway.model.AttachVolumeRequest.ReadOnly = new Wrapper(
    impl
  )
}
