package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteAutomaticTapeCreationPolicyResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse = {
    import DeleteAutomaticTapeCreationPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.ReadOnly =
    zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse
      .wrap(buildAwsValue())
}
object DeleteAutomaticTapeCreationPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse =
      zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse(
        gatewayARN.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse
  ) extends zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse
  ): zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
