package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{DiskId, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCacheResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    diskIds: Optional[Iterable[DiskId]] = Optional.Absent,
    cacheAllocatedInBytes: Optional[Long] = Optional.Absent,
    cacheUsedPercentage: Optional[Double] = Optional.Absent,
    cacheDirtyPercentage: Optional[Double] = Optional.Absent,
    cacheHitPercentage: Optional[Double] = Optional.Absent,
    cacheMissPercentage: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeCacheResponse = {
    import DescribeCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeCacheResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        diskIds.map(value =>
          value.map { item =>
            DiskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.diskIds)
      .optionallyWith(
        cacheAllocatedInBytes.map(value => value: java.lang.Long)
      )(_.cacheAllocatedInBytes)
      .optionallyWith(
        cacheUsedPercentage.map(value => value: java.lang.Double)
      )(_.cacheUsedPercentage)
      .optionallyWith(
        cacheDirtyPercentage.map(value => value: java.lang.Double)
      )(_.cacheDirtyPercentage)
      .optionallyWith(cacheHitPercentage.map(value => value: java.lang.Double))(
        _.cacheHitPercentage
      )
      .optionallyWith(
        cacheMissPercentage.map(value => value: java.lang.Double)
      )(_.cacheMissPercentage)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DescribeCacheResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeCacheResponse.wrap(buildAwsValue())
}
object DescribeCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeCacheResponse =
      zio.aws.storagegateway.model.DescribeCacheResponse(
        gatewayARN.map(value => value),
        diskIds.map(value => value),
        cacheAllocatedInBytes.map(value => value),
        cacheUsedPercentage.map(value => value),
        cacheDirtyPercentage.map(value => value),
        cacheHitPercentage.map(value => value),
        cacheMissPercentage.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def diskIds: Optional[List[DiskId]]
    def cacheAllocatedInBytes: Optional[Long]
    def cacheUsedPercentage: Optional[Double]
    def cacheDirtyPercentage: Optional[Double]
    def cacheHitPercentage: Optional[Double]
    def cacheMissPercentage: Optional[Double]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getDiskIds: ZIO[Any, AwsError, List[DiskId]] =
      AwsError.unwrapOptionField("diskIds", diskIds)
    def getCacheAllocatedInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("cacheAllocatedInBytes", cacheAllocatedInBytes)
    def getCacheUsedPercentage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("cacheUsedPercentage", cacheUsedPercentage)
    def getCacheDirtyPercentage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("cacheDirtyPercentage", cacheDirtyPercentage)
    def getCacheHitPercentage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("cacheHitPercentage", cacheHitPercentage)
    def getCacheMissPercentage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("cacheMissPercentage", cacheMissPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeCacheResponse
  ) extends zio.aws.storagegateway.model.DescribeCacheResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val diskIds: Optional[List[DiskId]] = zio.aws.core.internal
      .optionalFromNullable(impl.diskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.DiskId(item)
        }.toList
      )
    override val cacheAllocatedInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheAllocatedInBytes())
      .map(value => value: Long)
    override val cacheUsedPercentage: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheUsedPercentage())
      .map(value => value: Double)
    override val cacheDirtyPercentage: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheDirtyPercentage())
      .map(value => value: Double)
    override val cacheHitPercentage: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheHitPercentage())
      .map(value => value: Double)
    override val cacheMissPercentage: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheMissPercentage())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeCacheResponse
  ): zio.aws.storagegateway.model.DescribeCacheResponse.ReadOnly = new Wrapper(
    impl
  )
}
