package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  StorageClass,
  KMSKey,
  AuditDestinationARN,
  FileShareName,
  FileShareARN,
  Squash,
  IPV4AddressCIDR,
  NotificationPolicy
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateNfsFileShareRequest(
    fileShareARN: FileShareARN,
    kmsEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    nfsFileShareDefaults: Optional[
      zio.aws.storagegateway.model.NFSFileShareDefaults
    ] = Optional.Absent,
    defaultStorageClass: Optional[StorageClass] = Optional.Absent,
    objectACL: Optional[zio.aws.storagegateway.model.ObjectACL] =
      Optional.Absent,
    clientList: Optional[Iterable[IPV4AddressCIDR]] = Optional.Absent,
    squash: Optional[Squash] = Optional.Absent,
    readOnly: Optional[Boolean] = Optional.Absent,
    guessMIMETypeEnabled: Optional[Boolean] = Optional.Absent,
    requesterPays: Optional[Boolean] = Optional.Absent,
    fileShareName: Optional[FileShareName] = Optional.Absent,
    cacheAttributes: Optional[zio.aws.storagegateway.model.CacheAttributes] =
      Optional.Absent,
    notificationPolicy: Optional[NotificationPolicy] = Optional.Absent,
    auditDestinationARN: Optional[AuditDestinationARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareRequest = {
    import UpdateNfsFileShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareRequest
      .builder()
      .fileShareARN(FileShareARN.unwrap(fileShareARN): java.lang.String)
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(nfsFileShareDefaults.map(value => value.buildAwsValue()))(
        _.nfsFileShareDefaults
      )
      .optionallyWith(
        defaultStorageClass.map(value =>
          StorageClass.unwrap(value): java.lang.String
        )
      )(_.defaultStorageClass)
      .optionallyWith(objectACL.map(value => value.unwrap))(_.objectACL)
      .optionallyWith(
        clientList.map(value =>
          value.map { item =>
            IPV4AddressCIDR.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.clientList)
      .optionallyWith(
        squash.map(value => Squash.unwrap(value): java.lang.String)
      )(_.squash)
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        guessMIMETypeEnabled.map(value => value: java.lang.Boolean)
      )(_.guessMIMETypeEnabled)
      .optionallyWith(requesterPays.map(value => value: java.lang.Boolean))(
        _.requesterPays
      )
      .optionallyWith(
        fileShareName.map(value =>
          FileShareName.unwrap(value): java.lang.String
        )
      )(_.fileShareName)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .optionallyWith(
        notificationPolicy.map(value =>
          NotificationPolicy.unwrap(value): java.lang.String
        )
      )(_.notificationPolicy)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateNfsFileShareRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateNfsFileShareRequest.wrap(buildAwsValue())
}
object UpdateNfsFileShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateNfsFileShareRequest =
      zio.aws.storagegateway.model.UpdateNfsFileShareRequest(
        fileShareARN,
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        nfsFileShareDefaults.map(value => value.asEditable),
        defaultStorageClass.map(value => value),
        objectACL.map(value => value),
        clientList.map(value => value),
        squash.map(value => value),
        readOnly.map(value => value),
        guessMIMETypeEnabled.map(value => value),
        requesterPays.map(value => value),
        fileShareName.map(value => value),
        cacheAttributes.map(value => value.asEditable),
        notificationPolicy.map(value => value),
        auditDestinationARN.map(value => value)
      )
    def fileShareARN: FileShareARN
    def kmsEncrypted: Optional[Boolean]
    def kmsKey: Optional[KMSKey]
    def nfsFileShareDefaults
        : Optional[zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly]
    def defaultStorageClass: Optional[StorageClass]
    def objectACL: Optional[zio.aws.storagegateway.model.ObjectACL]
    def clientList: Optional[List[IPV4AddressCIDR]]
    def squash: Optional[Squash]
    def readOnly: Optional[Boolean]
    def guessMIMETypeEnabled: Optional[Boolean]
    def requesterPays: Optional[Boolean]
    def fileShareName: Optional[FileShareName]
    def cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def notificationPolicy: Optional[NotificationPolicy]
    def auditDestinationARN: Optional[AuditDestinationARN]
    def getFileShareARN: ZIO[Any, Nothing, FileShareARN] =
      ZIO.succeed(fileShareARN)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getNfsFileShareDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly
    ] = AwsError.unwrapOptionField("nfsFileShareDefaults", nfsFileShareDefaults)
    def getDefaultStorageClass: ZIO[Any, AwsError, StorageClass] =
      AwsError.unwrapOptionField("defaultStorageClass", defaultStorageClass)
    def getObjectACL
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.ObjectACL] =
      AwsError.unwrapOptionField("objectACL", objectACL)
    def getClientList: ZIO[Any, AwsError, List[IPV4AddressCIDR]] =
      AwsError.unwrapOptionField("clientList", clientList)
    def getSquash: ZIO[Any, AwsError, Squash] =
      AwsError.unwrapOptionField("squash", squash)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getGuessMIMETypeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("guessMIMETypeEnabled", guessMIMETypeEnabled)
    def getRequesterPays: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterPays", requesterPays)
    def getFileShareName: ZIO[Any, AwsError, FileShareName] =
      AwsError.unwrapOptionField("fileShareName", fileShareName)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
    def getNotificationPolicy: ZIO[Any, AwsError, NotificationPolicy] =
      AwsError.unwrapOptionField("notificationPolicy", notificationPolicy)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareRequest
  ) extends zio.aws.storagegateway.model.UpdateNfsFileShareRequest.ReadOnly {
    override val fileShareARN: FileShareARN =
      zio.aws.storagegateway.model.primitives.FileShareARN(impl.fileShareARN())
    override val kmsEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsEncrypted())
      .map(value => value: Boolean)
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val nfsFileShareDefaults
        : Optional[zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfsFileShareDefaults())
        .map(value =>
          zio.aws.storagegateway.model.NFSFileShareDefaults.wrap(value)
        )
    override val defaultStorageClass: Optional[StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultStorageClass())
        .map(value =>
          zio.aws.storagegateway.model.primitives.StorageClass(value)
        )
    override val objectACL: Optional[zio.aws.storagegateway.model.ObjectACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectACL())
        .map(value => zio.aws.storagegateway.model.ObjectACL.wrap(value))
    override val clientList: Optional[List[IPV4AddressCIDR]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.IPV4AddressCIDR(item)
          }.toList
        )
    override val squash: Optional[Squash] = zio.aws.core.internal
      .optionalFromNullable(impl.squash())
      .map(value => zio.aws.storagegateway.model.primitives.Squash(value))
    override val readOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: Boolean)
    override val guessMIMETypeEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.guessMIMETypeEnabled())
      .map(value => value: Boolean)
    override val requesterPays: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterPays())
      .map(value => value: Boolean)
    override val fileShareName: Optional[FileShareName] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareName())
      .map(value =>
        zio.aws.storagegateway.model.primitives.FileShareName(value)
      )
    override val cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheAttributes())
        .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
    override val notificationPolicy: Optional[NotificationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationPolicy())
        .map(value =>
          zio.aws.storagegateway.model.primitives.NotificationPolicy(value)
        )
    override val auditDestinationARN: Optional[AuditDestinationARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditDestinationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareRequest
  ): zio.aws.storagegateway.model.UpdateNfsFileShareRequest.ReadOnly =
    new Wrapper(impl)
}
