package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.TargetARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeChapCredentialsRequest(targetARN: TargetARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsRequest = {
    import DescribeChapCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsRequest
      .builder()
      .targetARN(TargetARN.unwrap(targetARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeChapCredentialsRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeChapCredentialsRequest
      .wrap(buildAwsValue())
}
object DescribeChapCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeChapCredentialsRequest =
      zio.aws.storagegateway.model.DescribeChapCredentialsRequest(targetARN)
    def targetARN: TargetARN
    def getTargetARN: ZIO[Any, Nothing, TargetARN] = ZIO.succeed(targetARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsRequest
  ) extends zio.aws.storagegateway.model.DescribeChapCredentialsRequest.ReadOnly {
    override val targetARN: TargetARN =
      zio.aws.storagegateway.model.primitives.TargetARN(impl.targetARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsRequest
  ): zio.aws.storagegateway.model.DescribeChapCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
