package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddUploadBufferResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AddUploadBufferResponse = {
    import AddUploadBufferResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AddUploadBufferResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AddUploadBufferResponse.ReadOnly =
    zio.aws.storagegateway.model.AddUploadBufferResponse.wrap(buildAwsValue())
}
object AddUploadBufferResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AddUploadBufferResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AddUploadBufferResponse =
      zio.aws.storagegateway.model
        .AddUploadBufferResponse(gatewayARN.map(value => value))
    def gatewayARN: Optional[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AddUploadBufferResponse
  ) extends zio.aws.storagegateway.model.AddUploadBufferResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AddUploadBufferResponse
  ): zio.aws.storagegateway.model.AddUploadBufferResponse.ReadOnly =
    new Wrapper(impl)
}
