package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeGatewayInformationRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest = {
    import DescribeGatewayInformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeGatewayInformationRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeGatewayInformationRequest
      .wrap(buildAwsValue())
}
object DescribeGatewayInformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeGatewayInformationRequest =
      zio.aws.storagegateway.model.DescribeGatewayInformationRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest
  ) extends zio.aws.storagegateway.model.DescribeGatewayInformationRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest
  ): zio.aws.storagegateway.model.DescribeGatewayInformationRequest.ReadOnly =
    new Wrapper(impl)
}
