package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkInterface(
    ipv4Address: Optional[String] = Optional.Absent,
    macAddress: Optional[String] = Optional.Absent,
    ipv6Address: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.NetworkInterface
      .builder()
      .optionallyWith(ipv4Address.map(value => value: java.lang.String))(
        _.ipv4Address
      )
      .optionallyWith(macAddress.map(value => value: java.lang.String))(
        _.macAddress
      )
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.NetworkInterface.ReadOnly =
    zio.aws.storagegateway.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.NetworkInterface =
      zio.aws.storagegateway.model.NetworkInterface(
        ipv4Address.map(value => value),
        macAddress.map(value => value),
        ipv6Address.map(value => value)
      )
    def ipv4Address: Optional[String]
    def macAddress: Optional[String]
    def ipv6Address: Optional[String]
    def getIpv4Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv4Address", ipv4Address)
    def getMacAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.NetworkInterface
  ) extends zio.aws.storagegateway.model.NetworkInterface.ReadOnly {
    override val ipv4Address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4Address())
      .map(value => value: String)
    override val macAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.macAddress())
      .map(value => value: String)
    override val ipv6Address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Address())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.NetworkInterface
  ): zio.aws.storagegateway.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
