package zio.aws.storagegateway.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  TapeRecoveryPointStatus,
  TapeSize,
  Time,
  TapeARN
}
import scala.jdk.CollectionConverters._
final case class TapeRecoveryPointInfo(
    tapeARN: Optional[TapeARN] = Optional.Absent,
    tapeRecoveryPointTime: Optional[Time] = Optional.Absent,
    tapeSizeInBytes: Optional[TapeSize] = Optional.Absent,
    tapeStatus: Optional[TapeRecoveryPointStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo = {
    import TapeRecoveryPointInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .optionallyWith(
        tapeRecoveryPointTime.map(value => Time.unwrap(value): Instant)
      )(_.tapeRecoveryPointTime)
      .optionallyWith(
        tapeSizeInBytes.map(value => TapeSize.unwrap(value): java.lang.Long)
      )(_.tapeSizeInBytes)
      .optionallyWith(
        tapeStatus.map(value =>
          TapeRecoveryPointStatus.unwrap(value): java.lang.String
        )
      )(_.tapeStatus)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly =
    zio.aws.storagegateway.model.TapeRecoveryPointInfo.wrap(buildAwsValue())
}
object TapeRecoveryPointInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.TapeRecoveryPointInfo =
      zio.aws.storagegateway.model.TapeRecoveryPointInfo(
        tapeARN.map(value => value),
        tapeRecoveryPointTime.map(value => value),
        tapeSizeInBytes.map(value => value),
        tapeStatus.map(value => value)
      )
    def tapeARN: Optional[TapeARN]
    def tapeRecoveryPointTime: Optional[Time]
    def tapeSizeInBytes: Optional[TapeSize]
    def tapeStatus: Optional[TapeRecoveryPointStatus]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
    def getTapeRecoveryPointTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("tapeRecoveryPointTime", tapeRecoveryPointTime)
    def getTapeSizeInBytes: ZIO[Any, AwsError, TapeSize] =
      AwsError.unwrapOptionField("tapeSizeInBytes", tapeSizeInBytes)
    def getTapeStatus: ZIO[Any, AwsError, TapeRecoveryPointStatus] =
      AwsError.unwrapOptionField("tapeStatus", tapeStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo
  ) extends zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly {
    override val tapeARN: Optional[TapeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
    override val tapeRecoveryPointTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeRecoveryPointTime())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val tapeSizeInBytes: Optional[TapeSize] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeSizeInBytes())
      .map(value => zio.aws.storagegateway.model.primitives.TapeSize(value))
    override val tapeStatus: Optional[TapeRecoveryPointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tapeStatus())
        .map(value =>
          zio.aws.storagegateway.model.primitives.TapeRecoveryPointStatus(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo
  ): zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly = new Wrapper(
    impl
  )
}
