package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAutomaticTapeCreationPolicyRequest(
    automaticTapeCreationRules: Iterable[
      zio.aws.storagegateway.model.AutomaticTapeCreationRule
    ],
    gatewayARN: GatewayARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest = {
    import UpdateAutomaticTapeCreationPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
      .builder()
      .automaticTapeCreationRules(automaticTapeCreationRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
      .wrap(buildAwsValue())
}
object UpdateAutomaticTapeCreationPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest =
      zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest(
        automaticTapeCreationRules.map { item =>
          item.asEditable
        },
        gatewayARN
      )
    def automaticTapeCreationRules
        : List[zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly]
    def gatewayARN: GatewayARN
    def getAutomaticTapeCreationRules: ZIO[Any, Nothing, List[
      zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly
    ]] = ZIO.succeed(automaticTapeCreationRules)
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
  ) extends zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest.ReadOnly {
    override val automaticTapeCreationRules: List[
      zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly
    ] = impl
      .automaticTapeCreationRules()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.AutomaticTapeCreationRule.wrap(item)
      }
      .toList
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
  ): zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
