package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChapCredentialsResponse(
    chapCredentials: Optional[Iterable[zio.aws.storagegateway.model.ChapInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsResponse = {
    import DescribeChapCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsResponse
      .builder()
      .optionallyWith(
        chapCredentials.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.chapCredentials)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeChapCredentialsResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeChapCredentialsResponse
      .wrap(buildAwsValue())
}
object DescribeChapCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeChapCredentialsResponse =
      zio.aws.storagegateway.model.DescribeChapCredentialsResponse(
        chapCredentials.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def chapCredentials
        : Optional[List[zio.aws.storagegateway.model.ChapInfo.ReadOnly]]
    def getChapCredentials: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.ChapInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("chapCredentials", chapCredentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsResponse
  ) extends zio.aws.storagegateway.model.DescribeChapCredentialsResponse.ReadOnly {
    override val chapCredentials
        : Optional[List[zio.aws.storagegateway.model.ChapInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.chapCredentials())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.ChapInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsResponse
  ): zio.aws.storagegateway.model.DescribeChapCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
