package zio.aws.storagegateway
import zio.aws.storagegateway.model.GatewayInfo.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.storagegateway.model.{
  DeleteGatewayRequest,
  UpdateAutomaticTapeCreationPolicyRequest,
  DescribeTapeArchivesRequest,
  ListFileSystemAssociationsRequest,
  AssignTapePoolRequest,
  DeleteBandwidthRateLimitRequest,
  StartAvailabilityMonitorTestRequest,
  DescribeNfsFileSharesRequest,
  DescribeWorkingStorageRequest,
  DeleteTapeRequest,
  ListLocalDisksRequest,
  CreateStorediScsiVolumeRequest,
  DeleteVolumeRequest,
  DescribeChapCredentialsRequest,
  StartGatewayRequest,
  ListAutomaticTapeCreationPoliciesRequest,
  ListVolumesRequest,
  ListFileSharesRequest,
  AddTagsToResourceRequest,
  UpdateSmbFileShareRequest,
  DescribeUploadBufferRequest,
  DisableGatewayRequest,
  DescribeMaintenanceStartTimeRequest,
  UpdateVtlDeviceTypeRequest,
  CreateNfsFileShareRequest,
  SetSmbGuestPasswordRequest,
  DescribeSmbSettingsRequest,
  SetLocalConsolePasswordRequest,
  DeleteTapePoolRequest,
  DeleteFileShareRequest,
  UpdateGatewaySoftwareNowRequest,
  ListTagsForResourceRequest,
  DetachVolumeRequest,
  AssociateFileSystemRequest,
  RetrieveTapeArchiveRequest,
  UpdateSmbFileShareVisibilityRequest,
  CancelArchivalRequest,
  DescribeCacheRequest,
  UpdateFileSystemAssociationRequest,
  CancelRetrievalRequest,
  DescribeTapeRecoveryPointsRequest,
  CreateCachediScsiVolumeRequest,
  DescribeTapesRequest,
  ListVolumeInitiatorsRequest,
  CreateTapeWithBarcodeRequest,
  RemoveTagsFromResourceRequest,
  ListTapesRequest,
  DescribeFileSystemAssociationsRequest,
  CreateSnapshotFromVolumeRecoveryPointRequest,
  ListVolumeRecoveryPointsRequest,
  JoinDomainRequest,
  UpdateNfsFileShareRequest,
  DescribeAvailabilityMonitorTestRequest,
  ListTapePoolsRequest,
  DescribeBandwidthRateLimitScheduleRequest,
  ShutdownGatewayRequest,
  UpdateBandwidthRateLimitRequest,
  NotifyWhenUploadedRequest,
  DescribeGatewayInformationRequest,
  CreateTapesRequest,
  DescribeBandwidthRateLimitRequest,
  AddWorkingStorageRequest,
  RetrieveTapeRecoveryPointRequest,
  DeleteTapeArchiveRequest,
  RefreshCacheRequest,
  CreateSmbFileShareRequest,
  DisassociateFileSystemRequest,
  CreateTapePoolRequest,
  UpdateChapCredentialsRequest,
  DescribeSmbFileSharesRequest,
  DescribeStorediScsiVolumesRequest,
  CreateSnapshotRequest,
  AddUploadBufferRequest,
  ActivateGatewayRequest,
  DeleteAutomaticTapeCreationPolicyRequest,
  ResetCacheRequest,
  ListGatewaysRequest,
  DescribeCachediScsiVolumesRequest,
  DescribeVtlDevicesRequest,
  DeleteChapCredentialsRequest,
  UpdateSmbSecurityStrategyRequest,
  UpdateSnapshotScheduleRequest,
  UpdateBandwidthRateLimitScheduleRequest,
  UpdateSmbLocalGroupsRequest,
  UpdateMaintenanceStartTimeRequest,
  DeleteSnapshotScheduleRequest,
  AddCacheRequest,
  AttachVolumeRequest,
  DescribeSnapshotScheduleRequest,
  UpdateGatewayInformationRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient
object StorageGatewayMock extends Mock[StorageGateway] {
  object ListAutomaticTapeCreationPolicies
      extends Effect[
        ListAutomaticTapeCreationPoliciesRequest,
        AwsError,
        zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.ReadOnly
      ]
  object AddTagsToResource
      extends Effect[
        AddTagsToResourceRequest,
        AwsError,
        zio.aws.storagegateway.model.AddTagsToResourceResponse.ReadOnly
      ]
  object CreateSMBFileShare
      extends Effect[
        CreateSmbFileShareRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateSmbFileShareResponse.ReadOnly
      ]
  object ListVolumeInitiators
      extends Effect[
        ListVolumeInitiatorsRequest,
        AwsError,
        zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.ReadOnly
      ]
  object JoinDomain
      extends Effect[
        JoinDomainRequest,
        AwsError,
        zio.aws.storagegateway.model.JoinDomainResponse.ReadOnly
      ]
  object ListVolumes
      extends Stream[
        ListVolumesRequest,
        AwsError,
        zio.aws.storagegateway.model.VolumeInfo.ReadOnly
      ]
  object ListVolumesPaginated
      extends Effect[
        ListVolumesRequest,
        AwsError,
        zio.aws.storagegateway.model.ListVolumesResponse.ReadOnly
      ]
  object DescribeAvailabilityMonitorTest
      extends Effect[
        DescribeAvailabilityMonitorTestRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.ReadOnly
      ]
  object DescribeChapCredentials
      extends Effect[
        DescribeChapCredentialsRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeChapCredentialsResponse.ReadOnly
      ]
  object RetrieveTapeArchive
      extends Effect[
        RetrieveTapeArchiveRequest,
        AwsError,
        zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.ReadOnly
      ]
  object UpdateBandwidthRateLimitSchedule
      extends Effect[
        UpdateBandwidthRateLimitScheduleRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.ReadOnly
      ]
  object DeleteFileShare
      extends Effect[
        DeleteFileShareRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteFileShareResponse.ReadOnly
      ]
  object DescribeCachediSCSIVolumes
      extends Effect[
        DescribeCachediScsiVolumesRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.ReadOnly
      ]
  object UpdateGatewayInformation
      extends Effect[
        UpdateGatewayInformationRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateGatewayInformationResponse.ReadOnly
      ]
  object DeleteTape
      extends Effect[
        DeleteTapeRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteTapeResponse.ReadOnly
      ]
  object UpdateMaintenanceStartTime
      extends Effect[
        UpdateMaintenanceStartTimeRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.ReadOnly
      ]
  object DeleteGateway
      extends Effect[
        DeleteGatewayRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteGatewayResponse.ReadOnly
      ]
  object DescribeTapes
      extends Stream[
        DescribeTapesRequest,
        AwsError,
        zio.aws.storagegateway.model.Tape.ReadOnly
      ]
  object DescribeTapesPaginated
      extends Effect[
        DescribeTapesRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeTapesResponse.ReadOnly
      ]
  object RefreshCache
      extends Effect[
        RefreshCacheRequest,
        AwsError,
        zio.aws.storagegateway.model.RefreshCacheResponse.ReadOnly
      ]
  object DescribeSMBSettings
      extends Effect[
        DescribeSmbSettingsRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly
      ]
  object DeleteChapCredentials
      extends Effect[
        DeleteChapCredentialsRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteChapCredentialsResponse.ReadOnly
      ]
  object ListFileSystemAssociations
      extends Stream[
        ListFileSystemAssociationsRequest,
        AwsError,
        zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly
      ]
  object ListFileSystemAssociationsPaginated
      extends Effect[
        ListFileSystemAssociationsRequest,
        AwsError,
        zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.ReadOnly
      ]
  object ShutdownGateway
      extends Effect[
        ShutdownGatewayRequest,
        AwsError,
        zio.aws.storagegateway.model.ShutdownGatewayResponse.ReadOnly
      ]
  object UpdateBandwidthRateLimit
      extends Effect[
        UpdateBandwidthRateLimitRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateBandwidthRateLimitResponse.ReadOnly
      ]
  object DeleteSnapshotSchedule
      extends Effect[
        DeleteSnapshotScheduleRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.ReadOnly
      ]
  object SetSMBGuestPassword
      extends Effect[
        SetSmbGuestPasswordRequest,
        AwsError,
        zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[
        RemoveTagsFromResourceRequest,
        AwsError,
        zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.ReadOnly
      ]
  object DescribeStorediSCSIVolumes
      extends Effect[
        DescribeStorediScsiVolumesRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.ReadOnly
      ]
  object DescribeCache
      extends Effect[
        DescribeCacheRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeCacheResponse.ReadOnly
      ]
  object AssignTapePool
      extends Effect[
        AssignTapePoolRequest,
        AwsError,
        zio.aws.storagegateway.model.AssignTapePoolResponse.ReadOnly
      ]
  object StartAvailabilityMonitorTest
      extends Effect[
        StartAvailabilityMonitorTestRequest,
        AwsError,
        zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.ReadOnly
      ]
  object StartGateway
      extends Effect[
        StartGatewayRequest,
        AwsError,
        zio.aws.storagegateway.model.StartGatewayResponse.ReadOnly
      ]
  object AddCache
      extends Effect[
        AddCacheRequest,
        AwsError,
        zio.aws.storagegateway.model.AddCacheResponse.ReadOnly
      ]
  object CreateNFSFileShare
      extends Effect[
        CreateNfsFileShareRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateNfsFileShareResponse.ReadOnly
      ]
  object ActivateGateway
      extends Effect[
        ActivateGatewayRequest,
        AwsError,
        zio.aws.storagegateway.model.ActivateGatewayResponse.ReadOnly
      ]
  object ListFileShares
      extends Stream[
        ListFileSharesRequest,
        AwsError,
        zio.aws.storagegateway.model.FileShareInfo.ReadOnly
      ]
  object ListFileSharesPaginated
      extends Effect[
        ListFileSharesRequest,
        AwsError,
        zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly
      ]
  object AddWorkingStorage
      extends Effect[
        AddWorkingStorageRequest,
        AwsError,
        zio.aws.storagegateway.model.AddWorkingStorageResponse.ReadOnly
      ]
  object UpdateAutomaticTapeCreationPolicy
      extends Effect[
        UpdateAutomaticTapeCreationPolicyRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse.ReadOnly
      ]
  object DisassociateFileSystem
      extends Effect[
        DisassociateFileSystemRequest,
        AwsError,
        zio.aws.storagegateway.model.DisassociateFileSystemResponse.ReadOnly
      ]
  object CancelArchival
      extends Effect[
        CancelArchivalRequest,
        AwsError,
        zio.aws.storagegateway.model.CancelArchivalResponse.ReadOnly
      ]
  object DescribeUploadBuffer
      extends Effect[
        DescribeUploadBufferRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeUploadBufferResponse.ReadOnly
      ]
  object DescribeBandwidthRateLimitSchedule
      extends Effect[
        DescribeBandwidthRateLimitScheduleRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.ReadOnly
      ]
  object AttachVolume
      extends Effect[
        AttachVolumeRequest,
        AwsError,
        zio.aws.storagegateway.model.AttachVolumeResponse.ReadOnly
      ]
  object DescribeSnapshotSchedule
      extends Effect[
        DescribeSnapshotScheduleRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.ReadOnly
      ]
  object DeleteBandwidthRateLimit
      extends Effect[
        DeleteBandwidthRateLimitRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.ReadOnly
      ]
  object ListTapes
      extends Stream[
        ListTapesRequest,
        AwsError,
        zio.aws.storagegateway.model.TapeInfo.ReadOnly
      ]
  object ListTapesPaginated
      extends Effect[
        ListTapesRequest,
        AwsError,
        zio.aws.storagegateway.model.ListTapesResponse.ReadOnly
      ]
  object DescribeTapeArchives
      extends Stream[
        DescribeTapeArchivesRequest,
        AwsError,
        zio.aws.storagegateway.model.TapeArchive.ReadOnly
      ]
  object DescribeTapeArchivesPaginated
      extends Effect[
        DescribeTapeArchivesRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeTapeArchivesResponse.ReadOnly
      ]
  object DescribeFileSystemAssociations
      extends Effect[
        DescribeFileSystemAssociationsRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.ReadOnly
      ]
  object DescribeWorkingStorage
      extends Effect[
        DescribeWorkingStorageRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeWorkingStorageResponse.ReadOnly
      ]
  object UpdateSMBSecurityStrategy
      extends Effect[
        UpdateSmbSecurityStrategyRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateSmbSecurityStrategyResponse.ReadOnly
      ]
  object ListLocalDisks
      extends Effect[
        ListLocalDisksRequest,
        AwsError,
        zio.aws.storagegateway.model.ListLocalDisksResponse.ReadOnly
      ]
  object DeleteTapePool
      extends Effect[
        DeleteTapePoolRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly
      ]
  object DescribeBandwidthRateLimit
      extends Effect[
        DescribeBandwidthRateLimitRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.ReadOnly
      ]
  object UpdateSMBFileShare
      extends Effect[
        UpdateSmbFileShareRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateSmbFileShareResponse.ReadOnly
      ]
  object RetrieveTapeRecoveryPoint
      extends Effect[
        RetrieveTapeRecoveryPointRequest,
        AwsError,
        zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.ReadOnly
      ]
  object CreateSnapshotFromVolumeRecoveryPoint
      extends Effect[
        CreateSnapshotFromVolumeRecoveryPointRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.ReadOnly
      ]
  object CreateCachediSCSIVolume
      extends Effect[
        CreateCachediScsiVolumeRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.storagegateway.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.storagegateway.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeNFSFileShares
      extends Effect[
        DescribeNfsFileSharesRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.ReadOnly
      ]
  object DeleteVolume
      extends Effect[
        DeleteVolumeRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteVolumeResponse.ReadOnly
      ]
  object UpdateChapCredentials
      extends Effect[
        UpdateChapCredentialsRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateChapCredentialsResponse.ReadOnly
      ]
  object NotifyWhenUploaded
      extends Effect[
        NotifyWhenUploadedRequest,
        AwsError,
        zio.aws.storagegateway.model.NotifyWhenUploadedResponse.ReadOnly
      ]
  object ResetCache
      extends Effect[
        ResetCacheRequest,
        AwsError,
        zio.aws.storagegateway.model.ResetCacheResponse.ReadOnly
      ]
  object UpdateGatewaySoftwareNow
      extends Effect[
        UpdateGatewaySoftwareNowRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
      ]
  object AssociateFileSystem
      extends Effect[
        AssociateFileSystemRequest,
        AwsError,
        zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly
      ]
  object SetLocalConsolePassword
      extends Effect[
        SetLocalConsolePasswordRequest,
        AwsError,
        zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.ReadOnly
      ]
  object DeleteAutomaticTapeCreationPolicy
      extends Effect[
        DeleteAutomaticTapeCreationPolicyRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.ReadOnly
      ]
  object AddUploadBuffer
      extends Effect[
        AddUploadBufferRequest,
        AwsError,
        zio.aws.storagegateway.model.AddUploadBufferResponse.ReadOnly
      ]
  object DescribeGatewayInformation
      extends Effect[
        DescribeGatewayInformationRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly
      ]
  object UpdateNFSFileShare
      extends Effect[
        UpdateNfsFileShareRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateNfsFileShareResponse.ReadOnly
      ]
  object DeleteTapeArchive
      extends Effect[
        DeleteTapeArchiveRequest,
        AwsError,
        zio.aws.storagegateway.model.DeleteTapeArchiveResponse.ReadOnly
      ]
  object UpdateSnapshotSchedule
      extends Effect[
        UpdateSnapshotScheduleRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.ReadOnly
      ]
  object CreateTapePool
      extends Effect[
        CreateTapePoolRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateTapePoolResponse.ReadOnly
      ]
  object CreateStorediSCSIVolume
      extends Effect[
        CreateStorediScsiVolumeRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.ReadOnly
      ]
  object ListVolumeRecoveryPoints
      extends Effect[
        ListVolumeRecoveryPointsRequest,
        AwsError,
        zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.ReadOnly
      ]
  object UpdateVTLDeviceType
      extends Effect[
        UpdateVtlDeviceTypeRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.ReadOnly
      ]
  object UpdateSMBFileShareVisibility
      extends Effect[
        UpdateSmbFileShareVisibilityRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityResponse.ReadOnly
      ]
  object DescribeVTLDevices
      extends Stream[
        DescribeVtlDevicesRequest,
        AwsError,
        zio.aws.storagegateway.model.VTLDevice.ReadOnly
      ]
  object DescribeVTLDevicesPaginated
      extends Effect[
        DescribeVtlDevicesRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly
      ]
  object ListTapePools
      extends Stream[
        ListTapePoolsRequest,
        AwsError,
        zio.aws.storagegateway.model.PoolInfo.ReadOnly
      ]
  object ListTapePoolsPaginated
      extends Effect[
        ListTapePoolsRequest,
        AwsError,
        zio.aws.storagegateway.model.ListTapePoolsResponse.ReadOnly
      ]
  object DisableGateway
      extends Effect[
        DisableGatewayRequest,
        AwsError,
        zio.aws.storagegateway.model.DisableGatewayResponse.ReadOnly
      ]
  object CreateTapes
      extends Effect[
        CreateTapesRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateTapesResponse.ReadOnly
      ]
  object UpdateFileSystemAssociation
      extends Effect[
        UpdateFileSystemAssociationRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly
      ]
  object DescribeTapeRecoveryPoints
      extends Stream[
        DescribeTapeRecoveryPointsRequest,
        AwsError,
        zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly
      ]
  object DescribeTapeRecoveryPointsPaginated
      extends Effect[
        DescribeTapeRecoveryPointsRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly
      ]
  object CancelRetrieval
      extends Effect[
        CancelRetrievalRequest,
        AwsError,
        zio.aws.storagegateway.model.CancelRetrievalResponse.ReadOnly
      ]
  object CreateTapeWithBarcode
      extends Effect[
        CreateTapeWithBarcodeRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateTapeWithBarcodeResponse.ReadOnly
      ]
  object DescribeSMBFileShares
      extends Effect[
        DescribeSmbFileSharesRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.ReadOnly
      ]
  object DetachVolume
      extends Effect[
        DetachVolumeRequest,
        AwsError,
        zio.aws.storagegateway.model.DetachVolumeResponse.ReadOnly
      ]
  object CreateSnapshot
      extends Effect[
        CreateSnapshotRequest,
        AwsError,
        zio.aws.storagegateway.model.CreateSnapshotResponse.ReadOnly
      ]
  object UpdateSMBLocalGroups
      extends Effect[
        UpdateSmbLocalGroupsRequest,
        AwsError,
        zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.ReadOnly
      ]
  object ListGateways extends Stream[ListGatewaysRequest, AwsError, ReadOnly]
  object ListGatewaysPaginated
      extends Effect[
        ListGatewaysRequest,
        AwsError,
        zio.aws.storagegateway.model.ListGatewaysResponse.ReadOnly
      ]
  object DescribeMaintenanceStartTime
      extends Effect[
        DescribeMaintenanceStartTimeRequest,
        AwsError,
        zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, StorageGateway] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, StorageGateway] { rts =>
        zio.ZIO.succeed {
          new StorageGateway {
            val api: StorageGatewayAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): StorageGateway = this
            def listAutomaticTapeCreationPolicies(
                request: ListAutomaticTapeCreationPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.ReadOnly
            ] = proxy(ListAutomaticTapeCreationPolicies, request)
            def addTagsToResource(request: AddTagsToResourceRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.AddTagsToResourceResponse.ReadOnly
            ] = proxy(AddTagsToResource, request)
            def createSMBFileShare(request: CreateSmbFileShareRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateSmbFileShareResponse.ReadOnly
            ] = proxy(CreateSMBFileShare, request)
            def listVolumeInitiators(request: ListVolumeInitiatorsRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.ReadOnly
            ] = proxy(ListVolumeInitiators, request)
            def joinDomain(request: JoinDomainRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.JoinDomainResponse.ReadOnly
            ] = proxy(JoinDomain, request)
            def listVolumes(request: ListVolumesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.VolumeInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVolumes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVolumesPaginated(request: ListVolumesRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ListVolumesResponse.ReadOnly
            ] = proxy(ListVolumesPaginated, request)
            def describeAvailabilityMonitorTest(
                request: DescribeAvailabilityMonitorTestRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.ReadOnly
            ] = proxy(DescribeAvailabilityMonitorTest, request)
            def describeChapCredentials(
                request: DescribeChapCredentialsRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeChapCredentialsResponse.ReadOnly
            ] = proxy(DescribeChapCredentials, request)
            def retrieveTapeArchive(request: RetrieveTapeArchiveRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.ReadOnly
            ] = proxy(RetrieveTapeArchive, request)
            def updateBandwidthRateLimitSchedule(
                request: UpdateBandwidthRateLimitScheduleRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.ReadOnly
            ] = proxy(UpdateBandwidthRateLimitSchedule, request)
            def deleteFileShare(request: DeleteFileShareRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteFileShareResponse.ReadOnly
            ] = proxy(DeleteFileShare, request)
            def describeCachediSCSIVolumes(
                request: DescribeCachediScsiVolumesRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.ReadOnly
            ] = proxy(DescribeCachediSCSIVolumes, request)
            def updateGatewayInformation(
                request: UpdateGatewayInformationRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateGatewayInformationResponse.ReadOnly
            ] = proxy(UpdateGatewayInformation, request)
            def deleteTape(request: DeleteTapeRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteTapeResponse.ReadOnly
            ] = proxy(DeleteTape, request)
            def updateMaintenanceStartTime(
                request: UpdateMaintenanceStartTimeRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.ReadOnly
            ] = proxy(UpdateMaintenanceStartTime, request)
            def deleteGateway(request: DeleteGatewayRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteGatewayResponse.ReadOnly
            ] = proxy(DeleteGateway, request)
            def describeTapes(request: DescribeTapesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.Tape.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeTapes, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeTapesPaginated(request: DescribeTapesRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeTapesResponse.ReadOnly
            ] = proxy(DescribeTapesPaginated, request)
            def refreshCache(request: RefreshCacheRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.RefreshCacheResponse.ReadOnly
            ] = proxy(RefreshCache, request)
            def describeSMBSettings(request: DescribeSmbSettingsRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly
            ] = proxy(DescribeSMBSettings, request)
            def deleteChapCredentials(
                request: DeleteChapCredentialsRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteChapCredentialsResponse.ReadOnly
            ] = proxy(DeleteChapCredentials, request)
            def listFileSystemAssociations(
                request: ListFileSystemAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFileSystemAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFileSystemAssociationsPaginated(
                request: ListFileSystemAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.ReadOnly
            ] = proxy(ListFileSystemAssociationsPaginated, request)
            def shutdownGateway(request: ShutdownGatewayRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ShutdownGatewayResponse.ReadOnly
            ] = proxy(ShutdownGateway, request)
            def updateBandwidthRateLimit(
                request: UpdateBandwidthRateLimitRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateBandwidthRateLimitResponse.ReadOnly
            ] = proxy(UpdateBandwidthRateLimit, request)
            def deleteSnapshotSchedule(
                request: DeleteSnapshotScheduleRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.ReadOnly
            ] = proxy(DeleteSnapshotSchedule, request)
            def setSMBGuestPassword(request: SetSmbGuestPasswordRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.ReadOnly
            ] = proxy(SetSMBGuestPassword, request)
            def removeTagsFromResource(
                request: RemoveTagsFromResourceRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.ReadOnly
            ] = proxy(RemoveTagsFromResource, request)
            def describeStorediSCSIVolumes(
                request: DescribeStorediScsiVolumesRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.ReadOnly
            ] = proxy(DescribeStorediSCSIVolumes, request)
            def describeCache(request: DescribeCacheRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeCacheResponse.ReadOnly
            ] = proxy(DescribeCache, request)
            def assignTapePool(request: AssignTapePoolRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.AssignTapePoolResponse.ReadOnly
            ] = proxy(AssignTapePool, request)
            def startAvailabilityMonitorTest(
                request: StartAvailabilityMonitorTestRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.ReadOnly
            ] = proxy(StartAvailabilityMonitorTest, request)
            def startGateway(request: StartGatewayRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.StartGatewayResponse.ReadOnly
            ] = proxy(StartGateway, request)
            def addCache(request: AddCacheRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.AddCacheResponse.ReadOnly
            ] = proxy(AddCache, request)
            def createNFSFileShare(request: CreateNfsFileShareRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateNfsFileShareResponse.ReadOnly
            ] = proxy(CreateNFSFileShare, request)
            def activateGateway(request: ActivateGatewayRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ActivateGatewayResponse.ReadOnly
            ] = proxy(ActivateGateway, request)
            def listFileShares(request: ListFileSharesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.FileShareInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFileShares, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFileSharesPaginated(request: ListFileSharesRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly
            ] = proxy(ListFileSharesPaginated, request)
            def addWorkingStorage(request: AddWorkingStorageRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.AddWorkingStorageResponse.ReadOnly
            ] = proxy(AddWorkingStorage, request)
            def updateAutomaticTapeCreationPolicy(
                request: UpdateAutomaticTapeCreationPolicyRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse.ReadOnly
            ] = proxy(UpdateAutomaticTapeCreationPolicy, request)
            def disassociateFileSystem(
                request: DisassociateFileSystemRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DisassociateFileSystemResponse.ReadOnly
            ] = proxy(DisassociateFileSystem, request)
            def cancelArchival(request: CancelArchivalRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.CancelArchivalResponse.ReadOnly
            ] = proxy(CancelArchival, request)
            def describeUploadBuffer(request: DescribeUploadBufferRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeUploadBufferResponse.ReadOnly
            ] = proxy(DescribeUploadBuffer, request)
            def describeBandwidthRateLimitSchedule(
                request: DescribeBandwidthRateLimitScheduleRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.ReadOnly
            ] = proxy(DescribeBandwidthRateLimitSchedule, request)
            def attachVolume(request: AttachVolumeRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.AttachVolumeResponse.ReadOnly
            ] = proxy(AttachVolume, request)
            def describeSnapshotSchedule(
                request: DescribeSnapshotScheduleRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.ReadOnly
            ] = proxy(DescribeSnapshotSchedule, request)
            def deleteBandwidthRateLimit(
                request: DeleteBandwidthRateLimitRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.ReadOnly
            ] = proxy(DeleteBandwidthRateLimit, request)
            def listTapes(request: ListTapesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.TapeInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTapes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTapesPaginated(request: ListTapesRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ListTapesResponse.ReadOnly
            ] = proxy(ListTapesPaginated, request)
            def describeTapeArchives(
                request: DescribeTapeArchivesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.TapeArchive.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeTapeArchives, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeTapeArchivesPaginated(
                request: DescribeTapeArchivesRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeTapeArchivesResponse.ReadOnly
            ] = proxy(DescribeTapeArchivesPaginated, request)
            def describeFileSystemAssociations(
                request: DescribeFileSystemAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.ReadOnly
            ] = proxy(DescribeFileSystemAssociations, request)
            def describeWorkingStorage(
                request: DescribeWorkingStorageRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeWorkingStorageResponse.ReadOnly
            ] = proxy(DescribeWorkingStorage, request)
            def updateSMBSecurityStrategy(
                request: UpdateSmbSecurityStrategyRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateSmbSecurityStrategyResponse.ReadOnly
            ] = proxy(UpdateSMBSecurityStrategy, request)
            def listLocalDisks(request: ListLocalDisksRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ListLocalDisksResponse.ReadOnly
            ] = proxy(ListLocalDisks, request)
            def deleteTapePool(request: DeleteTapePoolRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly
            ] = proxy(DeleteTapePool, request)
            def describeBandwidthRateLimit(
                request: DescribeBandwidthRateLimitRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.ReadOnly
            ] = proxy(DescribeBandwidthRateLimit, request)
            def updateSMBFileShare(request: UpdateSmbFileShareRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateSmbFileShareResponse.ReadOnly
            ] = proxy(UpdateSMBFileShare, request)
            def retrieveTapeRecoveryPoint(
                request: RetrieveTapeRecoveryPointRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.ReadOnly
            ] = proxy(RetrieveTapeRecoveryPoint, request)
            def createSnapshotFromVolumeRecoveryPoint(
                request: CreateSnapshotFromVolumeRecoveryPointRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.ReadOnly
            ] = proxy(CreateSnapshotFromVolumeRecoveryPoint, request)
            def createCachediSCSIVolume(
                request: CreateCachediScsiVolumeRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.ReadOnly
            ] = proxy(CreateCachediSCSIVolume, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.Tag.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTagsForResource, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def describeNFSFileShares(
                request: DescribeNfsFileSharesRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.ReadOnly
            ] = proxy(DescribeNFSFileShares, request)
            def deleteVolume(request: DeleteVolumeRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteVolumeResponse.ReadOnly
            ] = proxy(DeleteVolume, request)
            def updateChapCredentials(
                request: UpdateChapCredentialsRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateChapCredentialsResponse.ReadOnly
            ] = proxy(UpdateChapCredentials, request)
            def notifyWhenUploaded(request: NotifyWhenUploadedRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.NotifyWhenUploadedResponse.ReadOnly
            ] = proxy(NotifyWhenUploaded, request)
            def resetCache(request: ResetCacheRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ResetCacheResponse.ReadOnly
            ] = proxy(ResetCache, request)
            def updateGatewaySoftwareNow(
                request: UpdateGatewaySoftwareNowRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
            ] = proxy(UpdateGatewaySoftwareNow, request)
            def associateFileSystem(request: AssociateFileSystemRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly
            ] = proxy(AssociateFileSystem, request)
            def setLocalConsolePassword(
                request: SetLocalConsolePasswordRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.ReadOnly
            ] = proxy(SetLocalConsolePassword, request)
            def deleteAutomaticTapeCreationPolicy(
                request: DeleteAutomaticTapeCreationPolicyRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.ReadOnly
            ] = proxy(DeleteAutomaticTapeCreationPolicy, request)
            def addUploadBuffer(request: AddUploadBufferRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.AddUploadBufferResponse.ReadOnly
            ] = proxy(AddUploadBuffer, request)
            def describeGatewayInformation(
                request: DescribeGatewayInformationRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly
            ] = proxy(DescribeGatewayInformation, request)
            def updateNFSFileShare(request: UpdateNfsFileShareRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateNfsFileShareResponse.ReadOnly
            ] = proxy(UpdateNFSFileShare, request)
            def deleteTapeArchive(request: DeleteTapeArchiveRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DeleteTapeArchiveResponse.ReadOnly
            ] = proxy(DeleteTapeArchive, request)
            def updateSnapshotSchedule(
                request: UpdateSnapshotScheduleRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.ReadOnly
            ] = proxy(UpdateSnapshotSchedule, request)
            def createTapePool(request: CreateTapePoolRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateTapePoolResponse.ReadOnly
            ] = proxy(CreateTapePool, request)
            def createStorediSCSIVolume(
                request: CreateStorediScsiVolumeRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.ReadOnly
            ] = proxy(CreateStorediSCSIVolume, request)
            def listVolumeRecoveryPoints(
                request: ListVolumeRecoveryPointsRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.ReadOnly
            ] = proxy(ListVolumeRecoveryPoints, request)
            def updateVTLDeviceType(request: UpdateVtlDeviceTypeRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.ReadOnly
            ] = proxy(UpdateVTLDeviceType, request)
            def updateSMBFileShareVisibility(
                request: UpdateSmbFileShareVisibilityRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityResponse.ReadOnly
            ] = proxy(UpdateSMBFileShareVisibility, request)
            def describeVTLDevices(request: DescribeVtlDevicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.VTLDevice.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeVTLDevices, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeVTLDevicesPaginated(
                request: DescribeVtlDevicesRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly
            ] = proxy(DescribeVTLDevicesPaginated, request)
            def listTapePools(request: ListTapePoolsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.PoolInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTapePools, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTapePoolsPaginated(request: ListTapePoolsRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ListTapePoolsResponse.ReadOnly
            ] = proxy(ListTapePoolsPaginated, request)
            def disableGateway(request: DisableGatewayRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DisableGatewayResponse.ReadOnly
            ] = proxy(DisableGateway, request)
            def createTapes(request: CreateTapesRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateTapesResponse.ReadOnly
            ] = proxy(CreateTapes, request)
            def updateFileSystemAssociation(
                request: UpdateFileSystemAssociationRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly
            ] = proxy(UpdateFileSystemAssociation, request)
            def describeTapeRecoveryPoints(
                request: DescribeTapeRecoveryPointsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeTapeRecoveryPoints, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeTapeRecoveryPointsPaginated(
                request: DescribeTapeRecoveryPointsRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly
            ] = proxy(DescribeTapeRecoveryPointsPaginated, request)
            def cancelRetrieval(request: CancelRetrievalRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.CancelRetrievalResponse.ReadOnly
            ] = proxy(CancelRetrieval, request)
            def createTapeWithBarcode(
                request: CreateTapeWithBarcodeRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateTapeWithBarcodeResponse.ReadOnly
            ] = proxy(CreateTapeWithBarcode, request)
            def describeSMBFileShares(
                request: DescribeSmbFileSharesRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.ReadOnly
            ] = proxy(DescribeSMBFileShares, request)
            def detachVolume(request: DetachVolumeRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.DetachVolumeResponse.ReadOnly
            ] = proxy(DetachVolume, request)
            def createSnapshot(request: CreateSnapshotRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.CreateSnapshotResponse.ReadOnly
            ] = proxy(CreateSnapshot, request)
            def updateSMBLocalGroups(request: UpdateSmbLocalGroupsRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.ReadOnly
            ] = proxy(UpdateSMBLocalGroups, request)
            def listGateways(
                request: ListGatewaysRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListGateways, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listGatewaysPaginated(request: ListGatewaysRequest): IO[
              AwsError,
              zio.aws.storagegateway.model.ListGatewaysResponse.ReadOnly
            ] = proxy(ListGatewaysPaginated, request)
            def describeMaintenanceStartTime(
                request: DescribeMaintenanceStartTimeRequest
            ): IO[
              AwsError,
              zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.ReadOnly
            ] = proxy(DescribeMaintenanceStartTime, request)
          }
        }
      }
    }
  }
}
