package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  GatewayARN,
  FileShareStatus,
  FileShareId,
  FileShareARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FileShareInfo(
    fileShareType: Optional[zio.aws.storagegateway.model.FileShareType] =
      Optional.Absent,
    fileShareARN: Optional[FileShareARN] = Optional.Absent,
    fileShareId: Optional[FileShareId] = Optional.Absent,
    fileShareStatus: Optional[FileShareStatus] = Optional.Absent,
    gatewayARN: Optional[GatewayARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.FileShareInfo = {
    import FileShareInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.FileShareInfo
      .builder()
      .optionallyWith(fileShareType.map(value => value.unwrap))(_.fileShareType)
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .optionallyWith(
        fileShareId.map(value => FileShareId.unwrap(value): java.lang.String)
      )(_.fileShareId)
      .optionallyWith(
        fileShareStatus.map(value =>
          FileShareStatus.unwrap(value): java.lang.String
        )
      )(_.fileShareStatus)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.FileShareInfo.ReadOnly =
    zio.aws.storagegateway.model.FileShareInfo.wrap(buildAwsValue())
}
object FileShareInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.FileShareInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.FileShareInfo =
      zio.aws.storagegateway.model.FileShareInfo(
        fileShareType.map(value => value),
        fileShareARN.map(value => value),
        fileShareId.map(value => value),
        fileShareStatus.map(value => value),
        gatewayARN.map(value => value)
      )
    def fileShareType: Optional[zio.aws.storagegateway.model.FileShareType]
    def fileShareARN: Optional[FileShareARN]
    def fileShareId: Optional[FileShareId]
    def fileShareStatus: Optional[FileShareStatus]
    def gatewayARN: Optional[GatewayARN]
    def getFileShareType
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.FileShareType] =
      AwsError.unwrapOptionField("fileShareType", fileShareType)
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
    def getFileShareId: ZIO[Any, AwsError, FileShareId] =
      AwsError.unwrapOptionField("fileShareId", fileShareId)
    def getFileShareStatus: ZIO[Any, AwsError, FileShareStatus] =
      AwsError.unwrapOptionField("fileShareStatus", fileShareStatus)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.FileShareInfo
  ) extends zio.aws.storagegateway.model.FileShareInfo.ReadOnly {
    override val fileShareType
        : Optional[zio.aws.storagegateway.model.FileShareType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileShareType())
        .map(value => zio.aws.storagegateway.model.FileShareType.wrap(value))
    override val fileShareARN: Optional[FileShareARN] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
    override val fileShareId: Optional[FileShareId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareId())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareId(value))
    override val fileShareStatus: Optional[FileShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileShareStatus())
        .map(value =>
          zio.aws.storagegateway.model.primitives.FileShareStatus(value)
        )
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.FileShareInfo
  ): zio.aws.storagegateway.model.FileShareInfo.ReadOnly = new Wrapper(impl)
}
