package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{DiskId, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeUploadBufferResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    diskIds: Optional[Iterable[DiskId]] = Optional.Absent,
    uploadBufferUsedInBytes: Optional[Long] = Optional.Absent,
    uploadBufferAllocatedInBytes: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferResponse = {
    import DescribeUploadBufferResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        diskIds.map(value =>
          value.map { item =>
            DiskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.diskIds)
      .optionallyWith(
        uploadBufferUsedInBytes.map(value => value: java.lang.Long)
      )(_.uploadBufferUsedInBytes)
      .optionallyWith(
        uploadBufferAllocatedInBytes.map(value => value: java.lang.Long)
      )(_.uploadBufferAllocatedInBytes)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeUploadBufferResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeUploadBufferResponse
      .wrap(buildAwsValue())
}
object DescribeUploadBufferResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeUploadBufferResponse =
      zio.aws.storagegateway.model.DescribeUploadBufferResponse(
        gatewayARN.map(value => value),
        diskIds.map(value => value),
        uploadBufferUsedInBytes.map(value => value),
        uploadBufferAllocatedInBytes.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def diskIds: Optional[List[DiskId]]
    def uploadBufferUsedInBytes: Optional[Long]
    def uploadBufferAllocatedInBytes: Optional[Long]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getDiskIds: ZIO[Any, AwsError, List[DiskId]] =
      AwsError.unwrapOptionField("diskIds", diskIds)
    def getUploadBufferUsedInBytes: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("uploadBufferUsedInBytes", uploadBufferUsedInBytes)
    def getUploadBufferAllocatedInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "uploadBufferAllocatedInBytes",
        uploadBufferAllocatedInBytes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferResponse
  ) extends zio.aws.storagegateway.model.DescribeUploadBufferResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val diskIds: Optional[List[DiskId]] = zio.aws.core.internal
      .optionalFromNullable(impl.diskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.DiskId(item)
        }.toList
      )
    override val uploadBufferUsedInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadBufferUsedInBytes())
      .map(value => value: Long)
    override val uploadBufferAllocatedInBytes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploadBufferAllocatedInBytes())
        .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferResponse
  ): zio.aws.storagegateway.model.DescribeUploadBufferResponse.ReadOnly =
    new Wrapper(impl)
}
