package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  PoolARN
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTapePoolsRequest(
    poolARNs: Optional[Iterable[PoolARN]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    limit: Optional[PositiveIntObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest = {
    import ListTapePoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest
      .builder()
      .optionallyWith(
        poolARNs.map(value =>
          value.map { item =>
            PoolARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.poolARNs)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListTapePoolsRequest.ReadOnly =
    zio.aws.storagegateway.model.ListTapePoolsRequest.wrap(buildAwsValue())
}
object ListTapePoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListTapePoolsRequest =
      zio.aws.storagegateway.model.ListTapePoolsRequest(
        poolARNs.map(value => value),
        marker.map(value => value),
        limit.map(value => value)
      )
    def poolARNs: Optional[List[PoolARN]]
    def marker: Optional[Marker]
    def limit: Optional[PositiveIntObject]
    def getPoolARNs: ZIO[Any, AwsError, List[PoolARN]] =
      AwsError.unwrapOptionField("poolARNs", poolARNs)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest
  ) extends zio.aws.storagegateway.model.ListTapePoolsRequest.ReadOnly {
    override val poolARNs: Optional[List[PoolARN]] = zio.aws.core.internal
      .optionalFromNullable(impl.poolARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.PoolARN(item)
        }.toList
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Optional[PositiveIntObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest
  ): zio.aws.storagegateway.model.ListTapePoolsRequest.ReadOnly = new Wrapper(
    impl
  )
}
