package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeCachediScsiVolumesRequest(
    volumeARNs: Iterable[VolumeARN]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesRequest = {
    import DescribeCachediScsiVolumesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesRequest
      .builder()
      .volumeARNs(volumeARNs.map { item =>
        VolumeARN.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest
      .wrap(buildAwsValue())
}
object DescribeCachediScsiVolumesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest =
      zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest(volumeARNs)
    def volumeARNs: List[VolumeARN]
    def getVolumeARNs: ZIO[Any, Nothing, List[VolumeARN]] =
      ZIO.succeed(volumeARNs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesRequest
  ) extends zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest.ReadOnly {
    override val volumeARNs: List[VolumeARN] = impl
      .volumeARNs()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.primitives.VolumeARN(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesRequest
  ): zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest.ReadOnly =
    new Wrapper(impl)
}
