package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  RetentionLockTimeInDays,
  PoolName,
  PoolARN
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PoolInfo(
    poolARN: Optional[PoolARN] = Optional.Absent,
    poolName: Optional[PoolName] = Optional.Absent,
    storageClass: Optional[zio.aws.storagegateway.model.TapeStorageClass] =
      Optional.Absent,
    retentionLockType: Optional[
      zio.aws.storagegateway.model.RetentionLockType
    ] = Optional.Absent,
    retentionLockTimeInDays: Optional[RetentionLockTimeInDays] =
      Optional.Absent,
    poolStatus: Optional[zio.aws.storagegateway.model.PoolStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.PoolInfo = {
    import PoolInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.PoolInfo
      .builder()
      .optionallyWith(
        poolARN.map(value => PoolARN.unwrap(value): java.lang.String)
      )(_.poolARN)
      .optionallyWith(
        poolName.map(value => PoolName.unwrap(value): java.lang.String)
      )(_.poolName)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(retentionLockType.map(value => value.unwrap))(
        _.retentionLockType
      )
      .optionallyWith(
        retentionLockTimeInDays.map(value =>
          RetentionLockTimeInDays.unwrap(value): Integer
        )
      )(_.retentionLockTimeInDays)
      .optionallyWith(poolStatus.map(value => value.unwrap))(_.poolStatus)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.PoolInfo.ReadOnly =
    zio.aws.storagegateway.model.PoolInfo.wrap(buildAwsValue())
}
object PoolInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.PoolInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.PoolInfo =
      zio.aws.storagegateway.model.PoolInfo(
        poolARN.map(value => value),
        poolName.map(value => value),
        storageClass.map(value => value),
        retentionLockType.map(value => value),
        retentionLockTimeInDays.map(value => value),
        poolStatus.map(value => value)
      )
    def poolARN: Optional[PoolARN]
    def poolName: Optional[PoolName]
    def storageClass: Optional[zio.aws.storagegateway.model.TapeStorageClass]
    def retentionLockType
        : Optional[zio.aws.storagegateway.model.RetentionLockType]
    def retentionLockTimeInDays: Optional[RetentionLockTimeInDays]
    def poolStatus: Optional[zio.aws.storagegateway.model.PoolStatus]
    def getPoolARN: ZIO[Any, AwsError, PoolARN] =
      AwsError.unwrapOptionField("poolARN", poolARN)
    def getPoolName: ZIO[Any, AwsError, PoolName] =
      AwsError.unwrapOptionField("poolName", poolName)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.TapeStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getRetentionLockType
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.RetentionLockType] =
      AwsError.unwrapOptionField("retentionLockType", retentionLockType)
    def getRetentionLockTimeInDays
        : ZIO[Any, AwsError, RetentionLockTimeInDays] = AwsError
      .unwrapOptionField("retentionLockTimeInDays", retentionLockTimeInDays)
    def getPoolStatus
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.PoolStatus] =
      AwsError.unwrapOptionField("poolStatus", poolStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.PoolInfo
  ) extends zio.aws.storagegateway.model.PoolInfo.ReadOnly {
    override val poolARN: Optional[PoolARN] = zio.aws.core.internal
      .optionalFromNullable(impl.poolARN())
      .map(value => zio.aws.storagegateway.model.primitives.PoolARN(value))
    override val poolName: Optional[PoolName] = zio.aws.core.internal
      .optionalFromNullable(impl.poolName())
      .map(value => zio.aws.storagegateway.model.primitives.PoolName(value))
    override val storageClass
        : Optional[zio.aws.storagegateway.model.TapeStorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.storagegateway.model.TapeStorageClass.wrap(value))
    override val retentionLockType
        : Optional[zio.aws.storagegateway.model.RetentionLockType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionLockType())
        .map(value =>
          zio.aws.storagegateway.model.RetentionLockType.wrap(value)
        )
    override val retentionLockTimeInDays: Optional[RetentionLockTimeInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionLockTimeInDays())
        .map(value =>
          zio.aws.storagegateway.model.primitives.RetentionLockTimeInDays(value)
        )
    override val poolStatus: Optional[zio.aws.storagegateway.model.PoolStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.poolStatus())
        .map(value => zio.aws.storagegateway.model.PoolStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.PoolInfo
  ): zio.aws.storagegateway.model.PoolInfo.ReadOnly = new Wrapper(impl)
}
