package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{DeviceType, VTLDeviceARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateVtlDeviceTypeRequest(
    vtlDeviceARN: VTLDeviceARN,
    deviceType: DeviceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeRequest = {
    import UpdateVtlDeviceTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeRequest
      .builder()
      .vtlDeviceARN(VTLDeviceARN.unwrap(vtlDeviceARN): java.lang.String)
      .deviceType(DeviceType.unwrap(deviceType): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateVtlDeviceTypeRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateVtlDeviceTypeRequest
      .wrap(buildAwsValue())
}
object UpdateVtlDeviceTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateVtlDeviceTypeRequest =
      zio.aws.storagegateway.model
        .UpdateVtlDeviceTypeRequest(vtlDeviceARN, deviceType)
    def vtlDeviceARN: VTLDeviceARN
    def deviceType: DeviceType
    def getVtlDeviceARN: ZIO[Any, Nothing, VTLDeviceARN] =
      ZIO.succeed(vtlDeviceARN)
    def getDeviceType: ZIO[Any, Nothing, DeviceType] = ZIO.succeed(deviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeRequest
  ) extends zio.aws.storagegateway.model.UpdateVtlDeviceTypeRequest.ReadOnly {
    override val vtlDeviceARN: VTLDeviceARN =
      zio.aws.storagegateway.model.primitives.VTLDeviceARN(impl.vtlDeviceARN())
    override val deviceType: DeviceType =
      zio.aws.storagegateway.model.primitives.DeviceType(impl.deviceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeRequest
  ): zio.aws.storagegateway.model.UpdateVtlDeviceTypeRequest.ReadOnly =
    new Wrapper(impl)
}
