package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.ResourceARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RemoveTagsFromResourceResponse(
    resourceARN: Optional[ResourceARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceResponse = {
    import RemoveTagsFromResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceResponse
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.ReadOnly =
    zio.aws.storagegateway.model.RemoveTagsFromResourceResponse
      .wrap(buildAwsValue())
}
object RemoveTagsFromResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.RemoveTagsFromResourceResponse =
      zio.aws.storagegateway.model
        .RemoveTagsFromResourceResponse(resourceARN.map(value => value))
    def resourceARN: Optional[ResourceARN]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceResponse
  ) extends zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.ReadOnly {
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.storagegateway.model.primitives.ResourceARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceResponse
  ): zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.ReadOnly =
    new Wrapper(impl)
}
