package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{NotificationId, FileShareARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RefreshCacheResponse(
    fileShareARN: Optional[FileShareARN] = Optional.Absent,
    notificationId: Optional[NotificationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.RefreshCacheResponse = {
    import RefreshCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.RefreshCacheResponse
      .builder()
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .optionallyWith(
        notificationId.map(value =>
          NotificationId.unwrap(value): java.lang.String
        )
      )(_.notificationId)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.RefreshCacheResponse.ReadOnly =
    zio.aws.storagegateway.model.RefreshCacheResponse.wrap(buildAwsValue())
}
object RefreshCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.RefreshCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.RefreshCacheResponse =
      zio.aws.storagegateway.model.RefreshCacheResponse(
        fileShareARN.map(value => value),
        notificationId.map(value => value)
      )
    def fileShareARN: Optional[FileShareARN]
    def notificationId: Optional[NotificationId]
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
    def getNotificationId: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("notificationId", notificationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.RefreshCacheResponse
  ) extends zio.aws.storagegateway.model.RefreshCacheResponse.ReadOnly {
    override val fileShareARN: Optional[FileShareARN] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
    override val notificationId: Optional[NotificationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationId())
        .map(value =>
          zio.aws.storagegateway.model.primitives.NotificationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.RefreshCacheResponse
  ): zio.aws.storagegateway.model.RefreshCacheResponse.ReadOnly = new Wrapper(
    impl
  )
}
