package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileShareARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNfsFileShareResponse(
    fileShareARN: Optional[FileShareARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareResponse = {
    import CreateNfsFileShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareResponse
      .builder()
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateNfsFileShareResponse.ReadOnly =
    zio.aws.storagegateway.model.CreateNfsFileShareResponse
      .wrap(buildAwsValue())
}
object CreateNfsFileShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateNfsFileShareResponse =
      zio.aws.storagegateway.model
        .CreateNfsFileShareResponse(fileShareARN.map(value => value))
    def fileShareARN: Optional[FileShareARN]
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareResponse
  ) extends zio.aws.storagegateway.model.CreateNfsFileShareResponse.ReadOnly {
    override val fileShareARN: Optional[FileShareARN] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareResponse
  ): zio.aws.storagegateway.model.CreateNfsFileShareResponse.ReadOnly =
    new Wrapper(impl)
}
