package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  KMSKey,
  NetworkInterfaceId,
  DiskId,
  GatewayARN,
  SnapshotId,
  TargetName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStorediScsiVolumeRequest(
    gatewayARN: GatewayARN,
    diskId: DiskId,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    preserveExistingData: Boolean,
    targetName: TargetName,
    networkInterfaceId: NetworkInterfaceId,
    kmsEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.storagegateway.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeRequest = {
    import CreateStorediScsiVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .diskId(DiskId.unwrap(diskId): java.lang.String)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .preserveExistingData(preserveExistingData: java.lang.Boolean)
      .targetName(TargetName.unwrap(targetName): java.lang.String)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest.ReadOnly =
    zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest
      .wrap(buildAwsValue())
}
object CreateStorediScsiVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest =
      zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest(
        gatewayARN,
        diskId,
        snapshotId.map(value => value),
        preserveExistingData,
        targetName,
        networkInterfaceId,
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gatewayARN: GatewayARN
    def diskId: DiskId
    def snapshotId: Optional[SnapshotId]
    def preserveExistingData: Boolean
    def targetName: TargetName
    def networkInterfaceId: NetworkInterfaceId
    def kmsEncrypted: Optional[Boolean]
    def kmsKey: Optional[KMSKey]
    def tags: Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getDiskId: ZIO[Any, Nothing, DiskId] = ZIO.succeed(diskId)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getPreserveExistingData: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(preserveExistingData)
    def getTargetName: ZIO[Any, Nothing, TargetName] = ZIO.succeed(targetName)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeRequest
  ) extends zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val diskId: DiskId =
      zio.aws.storagegateway.model.primitives.DiskId(impl.diskId())
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.storagegateway.model.primitives.SnapshotId(value))
    override val preserveExistingData: Boolean =
      impl.preserveExistingData(): Boolean
    override val targetName: TargetName =
      zio.aws.storagegateway.model.primitives.TargetName(impl.targetName())
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.storagegateway.model.primitives
        .NetworkInterfaceId(impl.networkInterfaceId())
    override val kmsEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsEncrypted())
      .map(value => value: Boolean)
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val tags
        : Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeRequest
  ): zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest.ReadOnly =
    new Wrapper(impl)
}
