package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ShutdownGatewayRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayRequest = {
    import ShutdownGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ShutdownGatewayRequest.ReadOnly =
    zio.aws.storagegateway.model.ShutdownGatewayRequest.wrap(buildAwsValue())
}
object ShutdownGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ShutdownGatewayRequest =
      zio.aws.storagegateway.model.ShutdownGatewayRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayRequest
  ) extends zio.aws.storagegateway.model.ShutdownGatewayRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayRequest
  ): zio.aws.storagegateway.model.ShutdownGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
