package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  BandwidthDownloadRateLimit,
  HourOfDay,
  DayOfWeek,
  BandwidthUploadRateLimit,
  MinuteOfHour
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BandwidthRateLimitInterval(
    startHourOfDay: HourOfDay,
    startMinuteOfHour: MinuteOfHour,
    endHourOfDay: HourOfDay,
    endMinuteOfHour: MinuteOfHour,
    daysOfWeek: Iterable[DayOfWeek],
    averageUploadRateLimitInBitsPerSec: Optional[BandwidthUploadRateLimit] =
      Optional.Absent,
    averageDownloadRateLimitInBitsPerSec: Optional[BandwidthDownloadRateLimit] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.BandwidthRateLimitInterval = {
    import BandwidthRateLimitInterval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.BandwidthRateLimitInterval
      .builder()
      .startHourOfDay(HourOfDay.unwrap(startHourOfDay): Integer)
      .startMinuteOfHour(MinuteOfHour.unwrap(startMinuteOfHour): Integer)
      .endHourOfDay(HourOfDay.unwrap(endHourOfDay): Integer)
      .endMinuteOfHour(MinuteOfHour.unwrap(endMinuteOfHour): Integer)
      .daysOfWeek(daysOfWeek.map { item =>
        DayOfWeek.unwrap(item): Integer
      }.asJavaCollection)
      .optionallyWith(
        averageUploadRateLimitInBitsPerSec.map(value =>
          BandwidthUploadRateLimit.unwrap(value): java.lang.Long
        )
      )(_.averageUploadRateLimitInBitsPerSec)
      .optionallyWith(
        averageDownloadRateLimitInBitsPerSec.map(value =>
          BandwidthDownloadRateLimit.unwrap(value): java.lang.Long
        )
      )(_.averageDownloadRateLimitInBitsPerSec)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly =
    zio.aws.storagegateway.model.BandwidthRateLimitInterval
      .wrap(buildAwsValue())
}
object BandwidthRateLimitInterval {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.BandwidthRateLimitInterval
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.BandwidthRateLimitInterval =
      zio.aws.storagegateway.model.BandwidthRateLimitInterval(
        startHourOfDay,
        startMinuteOfHour,
        endHourOfDay,
        endMinuteOfHour,
        daysOfWeek,
        averageUploadRateLimitInBitsPerSec.map(value => value),
        averageDownloadRateLimitInBitsPerSec.map(value => value)
      )
    def startHourOfDay: HourOfDay
    def startMinuteOfHour: MinuteOfHour
    def endHourOfDay: HourOfDay
    def endMinuteOfHour: MinuteOfHour
    def daysOfWeek: List[DayOfWeek]
    def averageUploadRateLimitInBitsPerSec: Optional[BandwidthUploadRateLimit]
    def averageDownloadRateLimitInBitsPerSec
        : Optional[BandwidthDownloadRateLimit]
    def getStartHourOfDay: ZIO[Any, Nothing, HourOfDay] =
      ZIO.succeed(startHourOfDay)
    def getStartMinuteOfHour: ZIO[Any, Nothing, MinuteOfHour] =
      ZIO.succeed(startMinuteOfHour)
    def getEndHourOfDay: ZIO[Any, Nothing, HourOfDay] =
      ZIO.succeed(endHourOfDay)
    def getEndMinuteOfHour: ZIO[Any, Nothing, MinuteOfHour] =
      ZIO.succeed(endMinuteOfHour)
    def getDaysOfWeek: ZIO[Any, Nothing, List[DayOfWeek]] =
      ZIO.succeed(daysOfWeek)
    def getAverageUploadRateLimitInBitsPerSec
        : ZIO[Any, AwsError, BandwidthUploadRateLimit] =
      AwsError.unwrapOptionField(
        "averageUploadRateLimitInBitsPerSec",
        averageUploadRateLimitInBitsPerSec
      )
    def getAverageDownloadRateLimitInBitsPerSec
        : ZIO[Any, AwsError, BandwidthDownloadRateLimit] =
      AwsError.unwrapOptionField(
        "averageDownloadRateLimitInBitsPerSec",
        averageDownloadRateLimitInBitsPerSec
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.BandwidthRateLimitInterval
  ) extends zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly {
    override val startHourOfDay: HourOfDay =
      zio.aws.storagegateway.model.primitives.HourOfDay(impl.startHourOfDay())
    override val startMinuteOfHour: MinuteOfHour =
      zio.aws.storagegateway.model.primitives
        .MinuteOfHour(impl.startMinuteOfHour())
    override val endHourOfDay: HourOfDay =
      zio.aws.storagegateway.model.primitives.HourOfDay(impl.endHourOfDay())
    override val endMinuteOfHour: MinuteOfHour =
      zio.aws.storagegateway.model.primitives
        .MinuteOfHour(impl.endMinuteOfHour())
    override val daysOfWeek: List[DayOfWeek] = impl
      .daysOfWeek()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.primitives.DayOfWeek(item)
      }
      .toList
    override val averageUploadRateLimitInBitsPerSec
        : Optional[BandwidthUploadRateLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.averageUploadRateLimitInBitsPerSec())
      .map(value =>
        zio.aws.storagegateway.model.primitives.BandwidthUploadRateLimit(value)
      )
    override val averageDownloadRateLimitInBitsPerSec
        : Optional[BandwidthDownloadRateLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.averageDownloadRateLimitInBitsPerSec())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .BandwidthDownloadRateLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.BandwidthRateLimitInterval
  ): zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly =
    new Wrapper(impl)
}
