package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  Ec2InstanceId,
  GatewayId,
  Ec2InstanceRegion,
  SoftwareUpdatesEndDate,
  GatewayType,
  GatewayState,
  DeprecationDate,
  EndpointType,
  CloudWatchLogGroupARN,
  GatewayARN,
  HostEnvironmentId,
  GatewayTimezone,
  NextUpdateAvailabilityDate,
  LastSoftwareUpdate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeGatewayInformationResponse(
    gatewayARN: Option[GatewayARN] = None,
    gatewayId: Option[GatewayId] = None,
    gatewayName: Option[String] = None,
    gatewayTimezone: Option[GatewayTimezone] = None,
    gatewayState: Option[GatewayState] = None,
    gatewayNetworkInterfaces: Option[
      Iterable[zio.aws.storagegateway.model.NetworkInterface]
    ] = None,
    gatewayType: Option[GatewayType] = None,
    nextUpdateAvailabilityDate: Option[NextUpdateAvailabilityDate] = None,
    lastSoftwareUpdate: Option[LastSoftwareUpdate] = None,
    ec2InstanceId: Option[Ec2InstanceId] = None,
    ec2InstanceRegion: Option[Ec2InstanceRegion] = None,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None,
    vpcEndpoint: Option[String] = None,
    cloudWatchLogGroupARN: Option[CloudWatchLogGroupARN] = None,
    hostEnvironment: Option[zio.aws.storagegateway.model.HostEnvironment] =
      None,
    endpointType: Option[EndpointType] = None,
    softwareUpdatesEndDate: Option[SoftwareUpdatesEndDate] = None,
    deprecationDate: Option[DeprecationDate] = None,
    gatewayCapacity: Option[zio.aws.storagegateway.model.GatewayCapacity] =
      None,
    supportedGatewayCapacities: Option[
      Iterable[zio.aws.storagegateway.model.GatewayCapacity]
    ] = None,
    hostEnvironmentId: Option[HostEnvironmentId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse = {
    import DescribeGatewayInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        gatewayId.map(value => GatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(gatewayName.map(value => value: java.lang.String))(
        _.gatewayName
      )
      .optionallyWith(
        gatewayTimezone.map(value =>
          GatewayTimezone.unwrap(value): java.lang.String
        )
      )(_.gatewayTimezone)
      .optionallyWith(
        gatewayState.map(value => GatewayState.unwrap(value): java.lang.String)
      )(_.gatewayState)
      .optionallyWith(
        gatewayNetworkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gatewayNetworkInterfaces)
      .optionallyWith(
        gatewayType.map(value => GatewayType.unwrap(value): java.lang.String)
      )(_.gatewayType)
      .optionallyWith(
        nextUpdateAvailabilityDate.map(value =>
          NextUpdateAvailabilityDate.unwrap(value): java.lang.String
        )
      )(_.nextUpdateAvailabilityDate)
      .optionallyWith(
        lastSoftwareUpdate.map(value =>
          LastSoftwareUpdate.unwrap(value): java.lang.String
        )
      )(_.lastSoftwareUpdate)
      .optionallyWith(
        ec2InstanceId.map(value =>
          Ec2InstanceId.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceId)
      .optionallyWith(
        ec2InstanceRegion.map(value =>
          Ec2InstanceRegion.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceRegion)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcEndpoint.map(value => value: java.lang.String))(
        _.vpcEndpoint
      )
      .optionallyWith(
        cloudWatchLogGroupARN.map(value =>
          CloudWatchLogGroupARN.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupARN)
      .optionallyWith(hostEnvironment.map(value => value.unwrap))(
        _.hostEnvironment
      )
      .optionallyWith(
        endpointType.map(value => EndpointType.unwrap(value): java.lang.String)
      )(_.endpointType)
      .optionallyWith(
        softwareUpdatesEndDate.map(value =>
          SoftwareUpdatesEndDate.unwrap(value): java.lang.String
        )
      )(_.softwareUpdatesEndDate)
      .optionallyWith(
        deprecationDate.map(value =>
          DeprecationDate.unwrap(value): java.lang.String
        )
      )(_.deprecationDate)
      .optionallyWith(gatewayCapacity.map(value => value.unwrap))(
        _.gatewayCapacity
      )
      .optionallyWith(
        supportedGatewayCapacities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedGatewayCapacitiesWithStrings)
      .optionallyWith(
        hostEnvironmentId.map(value =>
          HostEnvironmentId.unwrap(value): java.lang.String
        )
      )(_.hostEnvironmentId)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeGatewayInformationResponse
      .wrap(buildAwsValue())
}
object DescribeGatewayInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeGatewayInformationResponse =
      zio.aws.storagegateway.model.DescribeGatewayInformationResponse(
        gatewayARN.map(value => value),
        gatewayId.map(value => value),
        gatewayName.map(value => value),
        gatewayTimezone.map(value => value),
        gatewayState.map(value => value),
        gatewayNetworkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gatewayType.map(value => value),
        nextUpdateAvailabilityDate.map(value => value),
        lastSoftwareUpdate.map(value => value),
        ec2InstanceId.map(value => value),
        ec2InstanceRegion.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpoint.map(value => value),
        cloudWatchLogGroupARN.map(value => value),
        hostEnvironment.map(value => value),
        endpointType.map(value => value),
        softwareUpdatesEndDate.map(value => value),
        deprecationDate.map(value => value),
        gatewayCapacity.map(value => value),
        supportedGatewayCapacities.map(value => value),
        hostEnvironmentId.map(value => value)
      )
    def gatewayARN: Option[GatewayARN]
    def gatewayId: Option[GatewayId]
    def gatewayName: Option[String]
    def gatewayTimezone: Option[GatewayTimezone]
    def gatewayState: Option[GatewayState]
    def gatewayNetworkInterfaces
        : Option[List[zio.aws.storagegateway.model.NetworkInterface.ReadOnly]]
    def gatewayType: Option[GatewayType]
    def nextUpdateAvailabilityDate: Option[NextUpdateAvailabilityDate]
    def lastSoftwareUpdate: Option[LastSoftwareUpdate]
    def ec2InstanceId: Option[Ec2InstanceId]
    def ec2InstanceRegion: Option[Ec2InstanceRegion]
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def vpcEndpoint: Option[String]
    def cloudWatchLogGroupARN: Option[CloudWatchLogGroupARN]
    def hostEnvironment: Option[zio.aws.storagegateway.model.HostEnvironment]
    def endpointType: Option[EndpointType]
    def softwareUpdatesEndDate: Option[SoftwareUpdatesEndDate]
    def deprecationDate: Option[DeprecationDate]
    def gatewayCapacity: Option[zio.aws.storagegateway.model.GatewayCapacity]
    def supportedGatewayCapacities
        : Option[List[zio.aws.storagegateway.model.GatewayCapacity]]
    def hostEnvironmentId: Option[HostEnvironmentId]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getGatewayId: ZIO[Any, AwsError, GatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getGatewayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayName", gatewayName)
    def getGatewayTimezone: ZIO[Any, AwsError, GatewayTimezone] =
      AwsError.unwrapOptionField("gatewayTimezone", gatewayTimezone)
    def getGatewayState: ZIO[Any, AwsError, GatewayState] =
      AwsError.unwrapOptionField("gatewayState", gatewayState)
    def getGatewayNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "gatewayNetworkInterfaces",
      gatewayNetworkInterfaces
    )
    def getGatewayType: ZIO[Any, AwsError, GatewayType] =
      AwsError.unwrapOptionField("gatewayType", gatewayType)
    def getNextUpdateAvailabilityDate
        : ZIO[Any, AwsError, NextUpdateAvailabilityDate] =
      AwsError.unwrapOptionField(
        "nextUpdateAvailabilityDate",
        nextUpdateAvailabilityDate
      )
    def getLastSoftwareUpdate: ZIO[Any, AwsError, LastSoftwareUpdate] =
      AwsError.unwrapOptionField("lastSoftwareUpdate", lastSoftwareUpdate)
    def getEc2InstanceId: ZIO[Any, AwsError, Ec2InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getEc2InstanceRegion: ZIO[Any, AwsError, Ec2InstanceRegion] =
      AwsError.unwrapOptionField("ec2InstanceRegion", ec2InstanceRegion)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
    def getCloudWatchLogGroupARN: ZIO[Any, AwsError, CloudWatchLogGroupARN] =
      AwsError.unwrapOptionField("cloudWatchLogGroupARN", cloudWatchLogGroupARN)
    def getHostEnvironment
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.HostEnvironment] =
      AwsError.unwrapOptionField("hostEnvironment", hostEnvironment)
    def getEndpointType: ZIO[Any, AwsError, EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getSoftwareUpdatesEndDate: ZIO[Any, AwsError, SoftwareUpdatesEndDate] =
      AwsError.unwrapOptionField(
        "softwareUpdatesEndDate",
        softwareUpdatesEndDate
      )
    def getDeprecationDate: ZIO[Any, AwsError, DeprecationDate] =
      AwsError.unwrapOptionField("deprecationDate", deprecationDate)
    def getGatewayCapacity
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.GatewayCapacity] =
      AwsError.unwrapOptionField("gatewayCapacity", gatewayCapacity)
    def getSupportedGatewayCapacities: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.GatewayCapacity
    ]] = AwsError.unwrapOptionField(
      "supportedGatewayCapacities",
      supportedGatewayCapacities
    )
    def getHostEnvironmentId: ZIO[Any, AwsError, HostEnvironmentId] =
      AwsError.unwrapOptionField("hostEnvironmentId", hostEnvironmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse
  ) extends zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val gatewayId: Option[GatewayId] = scala
      .Option(impl.gatewayId())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayId(value))
    override val gatewayName: Option[String] =
      scala.Option(impl.gatewayName()).map(value => value: String)
    override val gatewayTimezone: Option[GatewayTimezone] = scala
      .Option(impl.gatewayTimezone())
      .map(value =>
        zio.aws.storagegateway.model.primitives.GatewayTimezone(value)
      )
    override val gatewayState: Option[GatewayState] = scala
      .Option(impl.gatewayState())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayState(value))
    override val gatewayNetworkInterfaces
        : Option[List[zio.aws.storagegateway.model.NetworkInterface.ReadOnly]] =
      scala
        .Option(impl.gatewayNetworkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val gatewayType: Option[GatewayType] = scala
      .Option(impl.gatewayType())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayType(value))
    override val nextUpdateAvailabilityDate
        : Option[NextUpdateAvailabilityDate] = scala
      .Option(impl.nextUpdateAvailabilityDate())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .NextUpdateAvailabilityDate(value)
      )
    override val lastSoftwareUpdate: Option[LastSoftwareUpdate] = scala
      .Option(impl.lastSoftwareUpdate())
      .map(value =>
        zio.aws.storagegateway.model.primitives.LastSoftwareUpdate(value)
      )
    override val ec2InstanceId: Option[Ec2InstanceId] = scala
      .Option(impl.ec2InstanceId())
      .map(value =>
        zio.aws.storagegateway.model.primitives.Ec2InstanceId(value)
      )
    override val ec2InstanceRegion: Option[Ec2InstanceRegion] = scala
      .Option(impl.ec2InstanceRegion())
      .map(value =>
        zio.aws.storagegateway.model.primitives.Ec2InstanceRegion(value)
      )
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
    override val vpcEndpoint: Option[String] =
      scala.Option(impl.vpcEndpoint()).map(value => value: String)
    override val cloudWatchLogGroupARN: Option[CloudWatchLogGroupARN] = scala
      .Option(impl.cloudWatchLogGroupARN())
      .map(value =>
        zio.aws.storagegateway.model.primitives.CloudWatchLogGroupARN(value)
      )
    override val hostEnvironment
        : Option[zio.aws.storagegateway.model.HostEnvironment] = scala
      .Option(impl.hostEnvironment())
      .map(value => zio.aws.storagegateway.model.HostEnvironment.wrap(value))
    override val endpointType: Option[EndpointType] = scala
      .Option(impl.endpointType())
      .map(value => zio.aws.storagegateway.model.primitives.EndpointType(value))
    override val softwareUpdatesEndDate: Option[SoftwareUpdatesEndDate] = scala
      .Option(impl.softwareUpdatesEndDate())
      .map(value =>
        zio.aws.storagegateway.model.primitives.SoftwareUpdatesEndDate(value)
      )
    override val deprecationDate: Option[DeprecationDate] = scala
      .Option(impl.deprecationDate())
      .map(value =>
        zio.aws.storagegateway.model.primitives.DeprecationDate(value)
      )
    override val gatewayCapacity
        : Option[zio.aws.storagegateway.model.GatewayCapacity] = scala
      .Option(impl.gatewayCapacity())
      .map(value => zio.aws.storagegateway.model.GatewayCapacity.wrap(value))
    override val supportedGatewayCapacities
        : Option[List[zio.aws.storagegateway.model.GatewayCapacity]] = scala
      .Option(impl.supportedGatewayCapacities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.GatewayCapacity.wrap(item)
        }.toList
      )
    override val hostEnvironmentId: Option[HostEnvironmentId] = scala
      .Option(impl.hostEnvironmentId())
      .map(value =>
        zio.aws.storagegateway.model.primitives.HostEnvironmentId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse
  ): zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly =
    new Wrapper(impl)
}
