package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.UserListUser
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SMBLocalGroups(
    gatewayAdmins: Option[Iterable[UserListUser]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.SMBLocalGroups = {
    import SMBLocalGroups.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.SMBLocalGroups
      .builder()
      .optionallyWith(
        gatewayAdmins.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.gatewayAdmins)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly =
    zio.aws.storagegateway.model.SMBLocalGroups.wrap(buildAwsValue())
}
object SMBLocalGroups {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.SMBLocalGroups
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.SMBLocalGroups =
      zio.aws.storagegateway.model
        .SMBLocalGroups(gatewayAdmins.map(value => value))
    def gatewayAdmins: Option[List[UserListUser]]
    def getGatewayAdmins: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("gatewayAdmins", gatewayAdmins)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.SMBLocalGroups
  ) extends zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly {
    override val gatewayAdmins: Option[List[UserListUser]] = scala
      .Option(impl.gatewayAdmins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.UserListUser(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.SMBLocalGroups
  ): zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly = new Wrapper(impl)
}
