package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableGatewayResponse(gatewayARN: Option[GatewayARN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DisableGatewayResponse = {
    import DisableGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DisableGatewayResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DisableGatewayResponse.ReadOnly =
    zio.aws.storagegateway.model.DisableGatewayResponse.wrap(buildAwsValue())
}
object DisableGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DisableGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DisableGatewayResponse =
      zio.aws.storagegateway.model
        .DisableGatewayResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DisableGatewayResponse
  ) extends zio.aws.storagegateway.model.DisableGatewayResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DisableGatewayResponse
  ): zio.aws.storagegateway.model.DisableGatewayResponse.ReadOnly = new Wrapper(
    impl
  )
}
