package zio.aws.storagegateway
import zio.aws.storagegateway.model.GatewayInfo.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.storagegateway.paginators.{
  ListGatewaysPublisher,
  DescribeTapeRecoveryPointsPublisher,
  ListFileSystemAssociationsPublisher,
  ListVolumesPublisher,
  ListTagsForResourcePublisher,
  DescribeVTLDevicesPublisher,
  ListFileSharesPublisher,
  DescribeTapesPublisher,
  DescribeTapeArchivesPublisher,
  ListTapePoolsPublisher,
  ListTapesPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.storagegateway.model.{
  DeleteGatewayRequest,
  UpdateAutomaticTapeCreationPolicyRequest,
  UpdateSmbLocalGroupsResponse,
  DescribeTapeArchivesRequest,
  ListFileSystemAssociationsRequest,
  ActivateGatewayResponse,
  CancelArchivalResponse,
  PoolInfo,
  ResetCacheResponse,
  AssignTapePoolRequest,
  RefreshCacheResponse,
  DescribeSmbFileSharesResponse,
  ListTapesResponse,
  DeleteBandwidthRateLimitRequest,
  StartAvailabilityMonitorTestRequest,
  DescribeNfsFileSharesRequest,
  DescribeWorkingStorageRequest,
  DeleteTapeRequest,
  ListLocalDisksRequest,
  CreateStorediScsiVolumeRequest,
  DeleteChapCredentialsResponse,
  UpdateVtlDeviceTypeResponse,
  CreateSnapshotFromVolumeRecoveryPointResponse,
  DeleteGatewayResponse,
  DescribeGatewayInformationResponse,
  UpdateBandwidthRateLimitScheduleResponse,
  DeleteVolumeRequest,
  DescribeChapCredentialsRequest,
  CreateTapeWithBarcodeResponse,
  StartGatewayRequest,
  ListAutomaticTapeCreationPoliciesRequest,
  ListVolumesRequest,
  ListLocalDisksResponse,
  DeleteFileShareResponse,
  ListFileSharesRequest,
  AddTagsToResourceRequest,
  UpdateSmbFileShareRequest,
  DescribeTapeRecoveryPointsResponse,
  RemoveTagsFromResourceResponse,
  DescribeUploadBufferRequest,
  DescribeWorkingStorageResponse,
  DisableGatewayRequest,
  DescribeMaintenanceStartTimeRequest,
  StartAvailabilityMonitorTestResponse,
  UpdateVtlDeviceTypeRequest,
  UpdateMaintenanceStartTimeResponse,
  ListTapePoolsResponse,
  CreateNfsFileShareRequest,
  SetSmbGuestPasswordRequest,
  DescribeSmbSettingsRequest,
  SetLocalConsolePasswordRequest,
  ListVolumesResponse,
  DeleteTapeResponse,
  DeleteTapePoolRequest,
  DeleteFileShareRequest,
  UpdateGatewaySoftwareNowRequest,
  DescribeAvailabilityMonitorTestResponse,
  UpdateNfsFileShareResponse,
  ListGatewaysResponse,
  Tape,
  ListTagsForResourceRequest,
  UpdateSmbFileShareResponse,
  Tag,
  DetachVolumeRequest,
  AssociateFileSystemRequest,
  RetrieveTapeArchiveRequest,
  DescribeTapesResponse,
  UpdateSmbFileShareVisibilityRequest,
  CancelArchivalRequest,
  DescribeCacheResponse,
  ListFileSystemAssociationsResponse,
  DescribeCacheRequest,
  AddUploadBufferResponse,
  DeleteVolumeResponse,
  UpdateFileSystemAssociationRequest,
  ListTagsForResourceResponse,
  CancelRetrievalRequest,
  DescribeTapeRecoveryPointsRequest,
  DescribeTapeArchivesResponse,
  UpdateFileSystemAssociationResponse,
  UpdateAutomaticTapeCreationPolicyResponse,
  TapeArchive,
  CreateCachediScsiVolumeRequest,
  DescribeTapesRequest,
  AddCacheResponse,
  UpdateChapCredentialsResponse,
  DescribeFileSystemAssociationsResponse,
  AssociateFileSystemResponse,
  ListVolumeInitiatorsRequest,
  UpdateSmbFileShareVisibilityResponse,
  CreateTapeWithBarcodeRequest,
  UpdateSmbSecurityStrategyResponse,
  DeleteAutomaticTapeCreationPolicyResponse,
  DescribeNfsFileSharesResponse,
  RemoveTagsFromResourceRequest,
  ListVolumeRecoveryPointsResponse,
  UpdateGatewayInformationResponse,
  ListTapesRequest,
  DescribeFileSystemAssociationsRequest,
  DisassociateFileSystemResponse,
  CreateNfsFileShareResponse,
  CreateSnapshotFromVolumeRecoveryPointRequest,
  ListVolumeRecoveryPointsRequest,
  JoinDomainRequest,
  DescribeBandwidthRateLimitScheduleResponse,
  UpdateNfsFileShareRequest,
  DescribeBandwidthRateLimitResponse,
  CreateStorediScsiVolumeResponse,
  DescribeAvailabilityMonitorTestRequest,
  TapeRecoveryPointInfo,
  ListTapePoolsRequest,
  DeleteBandwidthRateLimitResponse,
  DescribeBandwidthRateLimitScheduleRequest,
  ShutdownGatewayRequest,
  CreateTapePoolResponse,
  UpdateBandwidthRateLimitRequest,
  NotifyWhenUploadedRequest,
  DescribeSnapshotScheduleResponse,
  JoinDomainResponse,
  CreateSmbFileShareResponse,
  DescribeCachediScsiVolumesResponse,
  TapeInfo,
  DescribeGatewayInformationRequest,
  CreateTapesRequest,
  DetachVolumeResponse,
  DeleteTapeArchiveResponse,
  RetrieveTapeArchiveResponse,
  ListAutomaticTapeCreationPoliciesResponse,
  DescribeChapCredentialsResponse,
  DescribeBandwidthRateLimitRequest,
  UpdateBandwidthRateLimitResponse,
  AddWorkingStorageRequest,
  DescribeUploadBufferResponse,
  FileSystemAssociationSummary,
  RetrieveTapeRecoveryPointRequest,
  ListFileSharesResponse,
  VTLDevice,
  DeleteTapeArchiveRequest,
  RefreshCacheRequest,
  CreateSmbFileShareRequest,
  DisassociateFileSystemRequest,
  AssignTapePoolResponse,
  CreateTapePoolRequest,
  AddTagsToResourceResponse,
  UpdateChapCredentialsRequest,
  DescribeSmbFileSharesRequest,
  DeleteTapePoolResponse,
  DescribeStorediScsiVolumesRequest,
  DescribeVtlDevicesResponse,
  CreateSnapshotRequest,
  AddUploadBufferRequest,
  ActivateGatewayRequest,
  SetLocalConsolePasswordResponse,
  DeleteAutomaticTapeCreationPolicyRequest,
  CreateTapesResponse,
  CreateCachediScsiVolumeResponse,
  RetrieveTapeRecoveryPointResponse,
  UpdateGatewaySoftwareNowResponse,
  ResetCacheRequest,
  FileShareInfo,
  SetSmbGuestPasswordResponse,
  NotifyWhenUploadedResponse,
  AttachVolumeResponse,
  ListVolumeInitiatorsResponse,
  DescribeSmbSettingsResponse,
  GatewayInfo,
  ListGatewaysRequest,
  DescribeCachediScsiVolumesRequest,
  DeleteSnapshotScheduleResponse,
  DescribeVtlDevicesRequest,
  DisableGatewayResponse,
  DeleteChapCredentialsRequest,
  UpdateSnapshotScheduleResponse,
  UpdateSmbSecurityStrategyRequest,
  UpdateSnapshotScheduleRequest,
  UpdateBandwidthRateLimitScheduleRequest,
  CreateSnapshotResponse,
  UpdateSmbLocalGroupsRequest,
  UpdateMaintenanceStartTimeRequest,
  DeleteSnapshotScheduleRequest,
  CancelRetrievalResponse,
  ShutdownGatewayResponse,
  AddWorkingStorageResponse,
  DescribeMaintenanceStartTimeResponse,
  AddCacheRequest,
  StartGatewayResponse,
  AttachVolumeRequest,
  VolumeInfo,
  DescribeSnapshotScheduleRequest,
  UpdateGatewayInformationRequest,
  DescribeStorediScsiVolumesResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.storagegateway.{
  StorageGatewayAsyncClientBuilder,
  StorageGatewayAsyncClient
}
import scala.jdk.CollectionConverters._
trait StorageGateway extends AspectSupport[StorageGateway] {
  val api: StorageGatewayAsyncClient
  def listAutomaticTapeCreationPolicies(
      request: zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.ReadOnly
  ]
  def addTagsToResource(
      request: zio.aws.storagegateway.model.AddTagsToResourceRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.AddTagsToResourceResponse.ReadOnly
  ]
  def createSMBFileShare(
      request: zio.aws.storagegateway.model.CreateSmbFileShareRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.CreateSmbFileShareResponse.ReadOnly
  ]
  def listVolumeInitiators(
      request: zio.aws.storagegateway.model.ListVolumeInitiatorsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.ReadOnly
  ]
  def joinDomain(
      request: zio.aws.storagegateway.model.JoinDomainRequest
  ): IO[AwsError, zio.aws.storagegateway.model.JoinDomainResponse.ReadOnly]
  def listVolumes(
      request: zio.aws.storagegateway.model.ListVolumesRequest
  ): ZStream[Any, AwsError, zio.aws.storagegateway.model.VolumeInfo.ReadOnly]
  def listVolumesPaginated(
      request: zio.aws.storagegateway.model.ListVolumesRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ListVolumesResponse.ReadOnly]
  def describeAvailabilityMonitorTest(
      request: zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.ReadOnly
  ]
  def describeChapCredentials(
      request: zio.aws.storagegateway.model.DescribeChapCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeChapCredentialsResponse.ReadOnly
  ]
  def retrieveTapeArchive(
      request: zio.aws.storagegateway.model.RetrieveTapeArchiveRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.ReadOnly
  ]
  def updateBandwidthRateLimitSchedule(
      request: zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.ReadOnly
  ]
  def deleteFileShare(
      request: zio.aws.storagegateway.model.DeleteFileShareRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DeleteFileShareResponse.ReadOnly]
  def describeCachediSCSIVolumes(
      request: zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.ReadOnly
  ]
  def updateGatewayInformation(
      request: zio.aws.storagegateway.model.UpdateGatewayInformationRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateGatewayInformationResponse.ReadOnly
  ]
  def deleteTape(
      request: zio.aws.storagegateway.model.DeleteTapeRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DeleteTapeResponse.ReadOnly]
  def updateMaintenanceStartTime(
      request: zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.ReadOnly
  ]
  def deleteGateway(
      request: zio.aws.storagegateway.model.DeleteGatewayRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DeleteGatewayResponse.ReadOnly]
  def describeTapes(
      request: zio.aws.storagegateway.model.DescribeTapesRequest
  ): ZStream[Any, AwsError, zio.aws.storagegateway.model.Tape.ReadOnly]
  def describeTapesPaginated(
      request: zio.aws.storagegateway.model.DescribeTapesRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DescribeTapesResponse.ReadOnly]
  def refreshCache(
      request: zio.aws.storagegateway.model.RefreshCacheRequest
  ): IO[AwsError, zio.aws.storagegateway.model.RefreshCacheResponse.ReadOnly]
  def describeSMBSettings(
      request: zio.aws.storagegateway.model.DescribeSmbSettingsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly
  ]
  def deleteChapCredentials(
      request: zio.aws.storagegateway.model.DeleteChapCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DeleteChapCredentialsResponse.ReadOnly
  ]
  def listFileSystemAssociations(
      request: zio.aws.storagegateway.model.ListFileSystemAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly
  ]
  def listFileSystemAssociationsPaginated(
      request: zio.aws.storagegateway.model.ListFileSystemAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.ReadOnly
  ]
  def shutdownGateway(
      request: zio.aws.storagegateway.model.ShutdownGatewayRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ShutdownGatewayResponse.ReadOnly]
  def updateBandwidthRateLimit(
      request: zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateBandwidthRateLimitResponse.ReadOnly
  ]
  def deleteSnapshotSchedule(
      request: zio.aws.storagegateway.model.DeleteSnapshotScheduleRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.ReadOnly
  ]
  def setSMBGuestPassword(
      request: zio.aws.storagegateway.model.SetSmbGuestPasswordRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.ReadOnly
  ]
  def removeTagsFromResource(
      request: zio.aws.storagegateway.model.RemoveTagsFromResourceRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.ReadOnly
  ]
  def describeStorediSCSIVolumes(
      request: zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.ReadOnly
  ]
  def describeCache(
      request: zio.aws.storagegateway.model.DescribeCacheRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DescribeCacheResponse.ReadOnly]
  def assignTapePool(
      request: zio.aws.storagegateway.model.AssignTapePoolRequest
  ): IO[AwsError, zio.aws.storagegateway.model.AssignTapePoolResponse.ReadOnly]
  def startAvailabilityMonitorTest(
      request: zio.aws.storagegateway.model.StartAvailabilityMonitorTestRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.ReadOnly
  ]
  def startGateway(
      request: zio.aws.storagegateway.model.StartGatewayRequest
  ): IO[AwsError, zio.aws.storagegateway.model.StartGatewayResponse.ReadOnly]
  def addCache(
      request: zio.aws.storagegateway.model.AddCacheRequest
  ): IO[AwsError, zio.aws.storagegateway.model.AddCacheResponse.ReadOnly]
  def createNFSFileShare(
      request: zio.aws.storagegateway.model.CreateNfsFileShareRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.CreateNfsFileShareResponse.ReadOnly
  ]
  def activateGateway(
      request: zio.aws.storagegateway.model.ActivateGatewayRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ActivateGatewayResponse.ReadOnly]
  def listFileShares(
      request: zio.aws.storagegateway.model.ListFileSharesRequest
  ): ZStream[Any, AwsError, zio.aws.storagegateway.model.FileShareInfo.ReadOnly]
  def listFileSharesPaginated(
      request: zio.aws.storagegateway.model.ListFileSharesRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly]
  def addWorkingStorage(
      request: zio.aws.storagegateway.model.AddWorkingStorageRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.AddWorkingStorageResponse.ReadOnly
  ]
  def updateAutomaticTapeCreationPolicy(
      request: zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse.ReadOnly
  ]
  def disassociateFileSystem(
      request: zio.aws.storagegateway.model.DisassociateFileSystemRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DisassociateFileSystemResponse.ReadOnly
  ]
  def cancelArchival(
      request: zio.aws.storagegateway.model.CancelArchivalRequest
  ): IO[AwsError, zio.aws.storagegateway.model.CancelArchivalResponse.ReadOnly]
  def describeUploadBuffer(
      request: zio.aws.storagegateway.model.DescribeUploadBufferRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeUploadBufferResponse.ReadOnly
  ]
  def describeBandwidthRateLimitSchedule(
      request: zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.ReadOnly
  ]
  def attachVolume(
      request: zio.aws.storagegateway.model.AttachVolumeRequest
  ): IO[AwsError, zio.aws.storagegateway.model.AttachVolumeResponse.ReadOnly]
  def describeSnapshotSchedule(
      request: zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.ReadOnly
  ]
  def deleteBandwidthRateLimit(
      request: zio.aws.storagegateway.model.DeleteBandwidthRateLimitRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.ReadOnly
  ]
  def listTapes(
      request: zio.aws.storagegateway.model.ListTapesRequest
  ): ZStream[Any, AwsError, zio.aws.storagegateway.model.TapeInfo.ReadOnly]
  def listTapesPaginated(
      request: zio.aws.storagegateway.model.ListTapesRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ListTapesResponse.ReadOnly]
  def describeTapeArchives(
      request: zio.aws.storagegateway.model.DescribeTapeArchivesRequest
  ): ZStream[Any, AwsError, zio.aws.storagegateway.model.TapeArchive.ReadOnly]
  def describeTapeArchivesPaginated(
      request: zio.aws.storagegateway.model.DescribeTapeArchivesRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeTapeArchivesResponse.ReadOnly
  ]
  def describeFileSystemAssociations(
      request: zio.aws.storagegateway.model.DescribeFileSystemAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.ReadOnly
  ]
  def describeWorkingStorage(
      request: zio.aws.storagegateway.model.DescribeWorkingStorageRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeWorkingStorageResponse.ReadOnly
  ]
  def updateSMBSecurityStrategy(
      request: zio.aws.storagegateway.model.UpdateSmbSecurityStrategyRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateSmbSecurityStrategyResponse.ReadOnly
  ]
  def listLocalDisks(
      request: zio.aws.storagegateway.model.ListLocalDisksRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ListLocalDisksResponse.ReadOnly]
  def deleteTapePool(
      request: zio.aws.storagegateway.model.DeleteTapePoolRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly]
  def describeBandwidthRateLimit(
      request: zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.ReadOnly
  ]
  def updateSMBFileShare(
      request: zio.aws.storagegateway.model.UpdateSmbFileShareRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateSmbFileShareResponse.ReadOnly
  ]
  def retrieveTapeRecoveryPoint(
      request: zio.aws.storagegateway.model.RetrieveTapeRecoveryPointRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.ReadOnly
  ]
  def createSnapshotFromVolumeRecoveryPoint(
      request: zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.ReadOnly
  ]
  def createCachediSCSIVolume(
      request: zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.storagegateway.model.ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.storagegateway.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: zio.aws.storagegateway.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.ListTagsForResourceResponse.ReadOnly
  ]
  def describeNFSFileShares(
      request: zio.aws.storagegateway.model.DescribeNfsFileSharesRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.ReadOnly
  ]
  def deleteVolume(
      request: zio.aws.storagegateway.model.DeleteVolumeRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DeleteVolumeResponse.ReadOnly]
  def updateChapCredentials(
      request: zio.aws.storagegateway.model.UpdateChapCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateChapCredentialsResponse.ReadOnly
  ]
  def notifyWhenUploaded(
      request: zio.aws.storagegateway.model.NotifyWhenUploadedRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.NotifyWhenUploadedResponse.ReadOnly
  ]
  def resetCache(
      request: zio.aws.storagegateway.model.ResetCacheRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ResetCacheResponse.ReadOnly]
  def updateGatewaySoftwareNow(
      request: zio.aws.storagegateway.model.UpdateGatewaySoftwareNowRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
  ]
  def associateFileSystem(
      request: zio.aws.storagegateway.model.AssociateFileSystemRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly
  ]
  def setLocalConsolePassword(
      request: zio.aws.storagegateway.model.SetLocalConsolePasswordRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.ReadOnly
  ]
  def deleteAutomaticTapeCreationPolicy(
      request: zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.ReadOnly
  ]
  def addUploadBuffer(
      request: zio.aws.storagegateway.model.AddUploadBufferRequest
  ): IO[AwsError, zio.aws.storagegateway.model.AddUploadBufferResponse.ReadOnly]
  def describeGatewayInformation(
      request: zio.aws.storagegateway.model.DescribeGatewayInformationRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly
  ]
  def updateNFSFileShare(
      request: zio.aws.storagegateway.model.UpdateNfsFileShareRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateNfsFileShareResponse.ReadOnly
  ]
  def deleteTapeArchive(
      request: zio.aws.storagegateway.model.DeleteTapeArchiveRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DeleteTapeArchiveResponse.ReadOnly
  ]
  def updateSnapshotSchedule(
      request: zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.ReadOnly
  ]
  def createTapePool(
      request: zio.aws.storagegateway.model.CreateTapePoolRequest
  ): IO[AwsError, zio.aws.storagegateway.model.CreateTapePoolResponse.ReadOnly]
  def createStorediSCSIVolume(
      request: zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.ReadOnly
  ]
  def listVolumeRecoveryPoints(
      request: zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.ReadOnly
  ]
  def updateVTLDeviceType(
      request: zio.aws.storagegateway.model.UpdateVtlDeviceTypeRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.ReadOnly
  ]
  def updateSMBFileShareVisibility(
      request: zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityResponse.ReadOnly
  ]
  def describeVTLDevices(
      request: zio.aws.storagegateway.model.DescribeVtlDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.storagegateway.model.VTLDevice.ReadOnly]
  def describeVTLDevicesPaginated(
      request: zio.aws.storagegateway.model.DescribeVtlDevicesRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly
  ]
  def listTapePools(
      request: zio.aws.storagegateway.model.ListTapePoolsRequest
  ): ZStream[Any, AwsError, zio.aws.storagegateway.model.PoolInfo.ReadOnly]
  def listTapePoolsPaginated(
      request: zio.aws.storagegateway.model.ListTapePoolsRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ListTapePoolsResponse.ReadOnly]
  def disableGateway(
      request: zio.aws.storagegateway.model.DisableGatewayRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DisableGatewayResponse.ReadOnly]
  def createTapes(
      request: zio.aws.storagegateway.model.CreateTapesRequest
  ): IO[AwsError, zio.aws.storagegateway.model.CreateTapesResponse.ReadOnly]
  def updateFileSystemAssociation(
      request: zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly
  ]
  def describeTapeRecoveryPoints(
      request: zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly
  ]
  def describeTapeRecoveryPointsPaginated(
      request: zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly
  ]
  def cancelRetrieval(
      request: zio.aws.storagegateway.model.CancelRetrievalRequest
  ): IO[AwsError, zio.aws.storagegateway.model.CancelRetrievalResponse.ReadOnly]
  def createTapeWithBarcode(
      request: zio.aws.storagegateway.model.CreateTapeWithBarcodeRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.CreateTapeWithBarcodeResponse.ReadOnly
  ]
  def describeSMBFileShares(
      request: zio.aws.storagegateway.model.DescribeSmbFileSharesRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.ReadOnly
  ]
  def detachVolume(
      request: zio.aws.storagegateway.model.DetachVolumeRequest
  ): IO[AwsError, zio.aws.storagegateway.model.DetachVolumeResponse.ReadOnly]
  def createSnapshot(
      request: zio.aws.storagegateway.model.CreateSnapshotRequest
  ): IO[AwsError, zio.aws.storagegateway.model.CreateSnapshotResponse.ReadOnly]
  def updateSMBLocalGroups(
      request: zio.aws.storagegateway.model.UpdateSmbLocalGroupsRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.ReadOnly
  ]
  def listGateways(
      request: zio.aws.storagegateway.model.ListGatewaysRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listGatewaysPaginated(
      request: zio.aws.storagegateway.model.ListGatewaysRequest
  ): IO[AwsError, zio.aws.storagegateway.model.ListGatewaysResponse.ReadOnly]
  def describeMaintenanceStartTime(
      request: zio.aws.storagegateway.model.DescribeMaintenanceStartTimeRequest
  ): IO[
    AwsError,
    zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.ReadOnly
  ]
}
object StorageGateway {
  val live: ZLayer[AwsConfig, java.lang.Throwable, StorageGateway] = customized(
    identity
  )
  def customized(
      customization: StorageGatewayAsyncClientBuilder => StorageGatewayAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, StorageGateway] = managed(
    customization
  ).toLayer
  def managed(
      customization: StorageGatewayAsyncClientBuilder => StorageGatewayAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, StorageGateway] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = StorageGatewayAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[StorageGatewayAsyncClient, StorageGatewayAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        StorageGatewayAsyncClient,
        StorageGatewayAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new StorageGatewayImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class StorageGatewayImpl[R](
      override val api: StorageGatewayAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends StorageGateway
      with AwsServiceBase[R] {
    override val serviceName: String = "StorageGateway"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): StorageGatewayImpl[R1] = new StorageGatewayImpl(api, newAspect, r)
    def listAutomaticTapeCreationPolicies(
        request: zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAutomaticTapeCreationPoliciesRequest,
      ListAutomaticTapeCreationPoliciesResponse
    ](
      "listAutomaticTapeCreationPolicies",
      api.listAutomaticTapeCreationPolicies
    )(request.buildAwsValue())
      .map(
        zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.wrap
      )
      .provideEnvironment(r)
    def addTagsToResource(
        request: zio.aws.storagegateway.model.AddTagsToResourceRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.AddTagsToResourceResponse.ReadOnly
    ] =
      asyncRequestResponse[AddTagsToResourceRequest, AddTagsToResourceResponse](
        "addTagsToResource",
        api.addTagsToResource
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.AddTagsToResourceResponse.wrap)
        .provideEnvironment(r)
    def createSMBFileShare(
        request: zio.aws.storagegateway.model.CreateSmbFileShareRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CreateSmbFileShareResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSmbFileShareRequest,
      CreateSmbFileShareResponse
    ]("createSMBFileShare", api.createSMBFileShare)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.CreateSmbFileShareResponse.wrap)
      .provideEnvironment(r)
    def listVolumeInitiators(
        request: zio.aws.storagegateway.model.ListVolumeInitiatorsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVolumeInitiatorsRequest,
      ListVolumeInitiatorsResponse
    ]("listVolumeInitiators", api.listVolumeInitiators)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.wrap)
      .provideEnvironment(r)
    def joinDomain(
        request: zio.aws.storagegateway.model.JoinDomainRequest
    ): IO[AwsError, zio.aws.storagegateway.model.JoinDomainResponse.ReadOnly] =
      asyncRequestResponse[JoinDomainRequest, JoinDomainResponse](
        "joinDomain",
        api.joinDomain
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.JoinDomainResponse.wrap)
        .provideEnvironment(r)
    def listVolumes(
        request: zio.aws.storagegateway.model.ListVolumesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.storagegateway.model.VolumeInfo.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListVolumesRequest,
      VolumeInfo,
      ListVolumesPublisher
    ]("listVolumes", api.listVolumesPaginator, _.volumeInfos())(
      request.buildAwsValue()
    ).map(item => zio.aws.storagegateway.model.VolumeInfo.wrap(item))
      .provideEnvironment(r)
    def listVolumesPaginated(
        request: zio.aws.storagegateway.model.ListVolumesRequest
    ): IO[AwsError, zio.aws.storagegateway.model.ListVolumesResponse.ReadOnly] =
      asyncRequestResponse[ListVolumesRequest, ListVolumesResponse](
        "listVolumes",
        api.listVolumes
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.ListVolumesResponse.wrap)
        .provideEnvironment(r)
    def describeAvailabilityMonitorTest(
        request: zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAvailabilityMonitorTestRequest,
      DescribeAvailabilityMonitorTestResponse
    ]("describeAvailabilityMonitorTest", api.describeAvailabilityMonitorTest)(
      request.buildAwsValue()
    ).map(
      zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.wrap
    ).provideEnvironment(r)
    def describeChapCredentials(
        request: zio.aws.storagegateway.model.DescribeChapCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeChapCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeChapCredentialsRequest,
      DescribeChapCredentialsResponse
    ]("describeChapCredentials", api.describeChapCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeChapCredentialsResponse.wrap)
      .provideEnvironment(r)
    def retrieveTapeArchive(
        request: zio.aws.storagegateway.model.RetrieveTapeArchiveRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.ReadOnly
    ] = asyncRequestResponse[
      RetrieveTapeArchiveRequest,
      RetrieveTapeArchiveResponse
    ]("retrieveTapeArchive", api.retrieveTapeArchive)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.wrap)
      .provideEnvironment(r)
    def updateBandwidthRateLimitSchedule(
        request: zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateBandwidthRateLimitScheduleRequest,
      UpdateBandwidthRateLimitScheduleResponse
    ]("updateBandwidthRateLimitSchedule", api.updateBandwidthRateLimitSchedule)(
      request.buildAwsValue()
    ).map(
      zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.wrap
    ).provideEnvironment(r)
    def deleteFileShare(
        request: zio.aws.storagegateway.model.DeleteFileShareRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteFileShareResponse.ReadOnly
    ] = asyncRequestResponse[DeleteFileShareRequest, DeleteFileShareResponse](
      "deleteFileShare",
      api.deleteFileShare
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DeleteFileShareResponse.wrap)
      .provideEnvironment(r)
    def describeCachediSCSIVolumes(
        request: zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCachediScsiVolumesRequest,
      DescribeCachediScsiVolumesResponse
    ]("describeCachediSCSIVolumes", api.describeCachediSCSIVolumes)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.wrap)
      .provideEnvironment(r)
    def updateGatewayInformation(
        request: zio.aws.storagegateway.model.UpdateGatewayInformationRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateGatewayInformationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGatewayInformationRequest,
      UpdateGatewayInformationResponse
    ]("updateGatewayInformation", api.updateGatewayInformation)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.UpdateGatewayInformationResponse.wrap)
      .provideEnvironment(r)
    def deleteTape(
        request: zio.aws.storagegateway.model.DeleteTapeRequest
    ): IO[AwsError, zio.aws.storagegateway.model.DeleteTapeResponse.ReadOnly] =
      asyncRequestResponse[DeleteTapeRequest, DeleteTapeResponse](
        "deleteTape",
        api.deleteTape
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.DeleteTapeResponse.wrap)
        .provideEnvironment(r)
    def updateMaintenanceStartTime(
        request: zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateMaintenanceStartTimeRequest,
      UpdateMaintenanceStartTimeResponse
    ]("updateMaintenanceStartTime", api.updateMaintenanceStartTime)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.wrap)
      .provideEnvironment(r)
    def deleteGateway(
        request: zio.aws.storagegateway.model.DeleteGatewayRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteGatewayResponse.ReadOnly
    ] = asyncRequestResponse[DeleteGatewayRequest, DeleteGatewayResponse](
      "deleteGateway",
      api.deleteGateway
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DeleteGatewayResponse.wrap)
      .provideEnvironment(r)
    def describeTapes(
        request: zio.aws.storagegateway.model.DescribeTapesRequest
    ): ZStream[Any, AwsError, zio.aws.storagegateway.model.Tape.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeTapesRequest,
        Tape,
        DescribeTapesPublisher
      ]("describeTapes", api.describeTapesPaginator, _.tapes())(
        request.buildAwsValue()
      ).map(item => zio.aws.storagegateway.model.Tape.wrap(item))
        .provideEnvironment(r)
    def describeTapesPaginated(
        request: zio.aws.storagegateway.model.DescribeTapesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeTapesResponse.ReadOnly
    ] = asyncRequestResponse[DescribeTapesRequest, DescribeTapesResponse](
      "describeTapes",
      api.describeTapes
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DescribeTapesResponse.wrap)
      .provideEnvironment(r)
    def refreshCache(
        request: zio.aws.storagegateway.model.RefreshCacheRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.RefreshCacheResponse.ReadOnly
    ] = asyncRequestResponse[RefreshCacheRequest, RefreshCacheResponse](
      "refreshCache",
      api.refreshCache
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.RefreshCacheResponse.wrap)
      .provideEnvironment(r)
    def describeSMBSettings(
        request: zio.aws.storagegateway.model.DescribeSmbSettingsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSmbSettingsRequest,
      DescribeSmbSettingsResponse
    ]("describeSMBSettings", api.describeSMBSettings)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DescribeSmbSettingsResponse.wrap)
      .provideEnvironment(r)
    def deleteChapCredentials(
        request: zio.aws.storagegateway.model.DeleteChapCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteChapCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteChapCredentialsRequest,
      DeleteChapCredentialsResponse
    ]("deleteChapCredentials", api.deleteChapCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DeleteChapCredentialsResponse.wrap)
      .provideEnvironment(r)
    def listFileSystemAssociations(
        request: zio.aws.storagegateway.model.ListFileSystemAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListFileSystemAssociationsRequest,
      FileSystemAssociationSummary,
      ListFileSystemAssociationsPublisher
    ](
      "listFileSystemAssociations",
      api.listFileSystemAssociationsPaginator,
      _.fileSystemAssociationSummaryList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.storagegateway.model.FileSystemAssociationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listFileSystemAssociationsPaginated(
        request: zio.aws.storagegateway.model.ListFileSystemAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListFileSystemAssociationsRequest,
      ListFileSystemAssociationsResponse
    ]("listFileSystemAssociations", api.listFileSystemAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.wrap)
      .provideEnvironment(r)
    def shutdownGateway(
        request: zio.aws.storagegateway.model.ShutdownGatewayRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ShutdownGatewayResponse.ReadOnly
    ] = asyncRequestResponse[ShutdownGatewayRequest, ShutdownGatewayResponse](
      "shutdownGateway",
      api.shutdownGateway
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.ShutdownGatewayResponse.wrap)
      .provideEnvironment(r)
    def updateBandwidthRateLimit(
        request: zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateBandwidthRateLimitResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateBandwidthRateLimitRequest,
      UpdateBandwidthRateLimitResponse
    ]("updateBandwidthRateLimit", api.updateBandwidthRateLimit)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.UpdateBandwidthRateLimitResponse.wrap)
      .provideEnvironment(r)
    def deleteSnapshotSchedule(
        request: zio.aws.storagegateway.model.DeleteSnapshotScheduleRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSnapshotScheduleRequest,
      DeleteSnapshotScheduleResponse
    ]("deleteSnapshotSchedule", api.deleteSnapshotSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.wrap)
      .provideEnvironment(r)
    def setSMBGuestPassword(
        request: zio.aws.storagegateway.model.SetSmbGuestPasswordRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      SetSmbGuestPasswordRequest,
      SetSmbGuestPasswordResponse
    ]("setSMBGuestPassword", api.setSMBGuestPassword)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.wrap)
      .provideEnvironment(r)
    def removeTagsFromResource(
        request: zio.aws.storagegateway.model.RemoveTagsFromResourceRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveTagsFromResourceRequest,
      RemoveTagsFromResourceResponse
    ]("removeTagsFromResource", api.removeTagsFromResource)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.wrap)
      .provideEnvironment(r)
    def describeStorediSCSIVolumes(
        request: zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeStorediScsiVolumesRequest,
      DescribeStorediScsiVolumesResponse
    ]("describeStorediSCSIVolumes", api.describeStorediSCSIVolumes)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.wrap)
      .provideEnvironment(r)
    def describeCache(
        request: zio.aws.storagegateway.model.DescribeCacheRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeCacheResponse.ReadOnly
    ] = asyncRequestResponse[DescribeCacheRequest, DescribeCacheResponse](
      "describeCache",
      api.describeCache
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DescribeCacheResponse.wrap)
      .provideEnvironment(r)
    def assignTapePool(
        request: zio.aws.storagegateway.model.AssignTapePoolRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.AssignTapePoolResponse.ReadOnly
    ] = asyncRequestResponse[AssignTapePoolRequest, AssignTapePoolResponse](
      "assignTapePool",
      api.assignTapePool
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.AssignTapePoolResponse.wrap)
      .provideEnvironment(r)
    def startAvailabilityMonitorTest(
        request: zio.aws.storagegateway.model.StartAvailabilityMonitorTestRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.ReadOnly
    ] = asyncRequestResponse[
      StartAvailabilityMonitorTestRequest,
      StartAvailabilityMonitorTestResponse
    ]("startAvailabilityMonitorTest", api.startAvailabilityMonitorTest)(
      request.buildAwsValue()
    ).map(
      zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.wrap
    ).provideEnvironment(r)
    def startGateway(
        request: zio.aws.storagegateway.model.StartGatewayRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.StartGatewayResponse.ReadOnly
    ] = asyncRequestResponse[StartGatewayRequest, StartGatewayResponse](
      "startGateway",
      api.startGateway
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.StartGatewayResponse.wrap)
      .provideEnvironment(r)
    def addCache(
        request: zio.aws.storagegateway.model.AddCacheRequest
    ): IO[AwsError, zio.aws.storagegateway.model.AddCacheResponse.ReadOnly] =
      asyncRequestResponse[AddCacheRequest, AddCacheResponse](
        "addCache",
        api.addCache
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.AddCacheResponse.wrap)
        .provideEnvironment(r)
    def createNFSFileShare(
        request: zio.aws.storagegateway.model.CreateNfsFileShareRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CreateNfsFileShareResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateNfsFileShareRequest,
      CreateNfsFileShareResponse
    ]("createNFSFileShare", api.createNFSFileShare)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.CreateNfsFileShareResponse.wrap)
      .provideEnvironment(r)
    def activateGateway(
        request: zio.aws.storagegateway.model.ActivateGatewayRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ActivateGatewayResponse.ReadOnly
    ] = asyncRequestResponse[ActivateGatewayRequest, ActivateGatewayResponse](
      "activateGateway",
      api.activateGateway
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.ActivateGatewayResponse.wrap)
      .provideEnvironment(r)
    def listFileShares(
        request: zio.aws.storagegateway.model.ListFileSharesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.storagegateway.model.FileShareInfo.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListFileSharesRequest,
      FileShareInfo,
      ListFileSharesPublisher
    ]("listFileShares", api.listFileSharesPaginator, _.fileShareInfoList())(
      request.buildAwsValue()
    ).map(item => zio.aws.storagegateway.model.FileShareInfo.wrap(item))
      .provideEnvironment(r)
    def listFileSharesPaginated(
        request: zio.aws.storagegateway.model.ListFileSharesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly
    ] = asyncRequestResponse[ListFileSharesRequest, ListFileSharesResponse](
      "listFileShares",
      api.listFileShares
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.ListFileSharesResponse.wrap)
      .provideEnvironment(r)
    def addWorkingStorage(
        request: zio.aws.storagegateway.model.AddWorkingStorageRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.AddWorkingStorageResponse.ReadOnly
    ] =
      asyncRequestResponse[AddWorkingStorageRequest, AddWorkingStorageResponse](
        "addWorkingStorage",
        api.addWorkingStorage
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.AddWorkingStorageResponse.wrap)
        .provideEnvironment(r)
    def updateAutomaticTapeCreationPolicy(
        request: zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateAutomaticTapeCreationPolicyRequest,
      UpdateAutomaticTapeCreationPolicyResponse
    ](
      "updateAutomaticTapeCreationPolicy",
      api.updateAutomaticTapeCreationPolicy
    )(request.buildAwsValue())
      .map(
        zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateFileSystem(
        request: zio.aws.storagegateway.model.DisassociateFileSystemRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DisassociateFileSystemResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateFileSystemRequest,
      DisassociateFileSystemResponse
    ]("disassociateFileSystem", api.disassociateFileSystem)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DisassociateFileSystemResponse.wrap)
      .provideEnvironment(r)
    def cancelArchival(
        request: zio.aws.storagegateway.model.CancelArchivalRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CancelArchivalResponse.ReadOnly
    ] = asyncRequestResponse[CancelArchivalRequest, CancelArchivalResponse](
      "cancelArchival",
      api.cancelArchival
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.CancelArchivalResponse.wrap)
      .provideEnvironment(r)
    def describeUploadBuffer(
        request: zio.aws.storagegateway.model.DescribeUploadBufferRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeUploadBufferResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeUploadBufferRequest,
      DescribeUploadBufferResponse
    ]("describeUploadBuffer", api.describeUploadBuffer)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DescribeUploadBufferResponse.wrap)
      .provideEnvironment(r)
    def describeBandwidthRateLimitSchedule(
        request: zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeBandwidthRateLimitScheduleRequest,
      DescribeBandwidthRateLimitScheduleResponse
    ](
      "describeBandwidthRateLimitSchedule",
      api.describeBandwidthRateLimitSchedule
    )(request.buildAwsValue())
      .map(
        zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.wrap
      )
      .provideEnvironment(r)
    def attachVolume(
        request: zio.aws.storagegateway.model.AttachVolumeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.AttachVolumeResponse.ReadOnly
    ] = asyncRequestResponse[AttachVolumeRequest, AttachVolumeResponse](
      "attachVolume",
      api.attachVolume
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.AttachVolumeResponse.wrap)
      .provideEnvironment(r)
    def describeSnapshotSchedule(
        request: zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSnapshotScheduleRequest,
      DescribeSnapshotScheduleResponse
    ]("describeSnapshotSchedule", api.describeSnapshotSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.wrap)
      .provideEnvironment(r)
    def deleteBandwidthRateLimit(
        request: zio.aws.storagegateway.model.DeleteBandwidthRateLimitRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteBandwidthRateLimitRequest,
      DeleteBandwidthRateLimitResponse
    ]("deleteBandwidthRateLimit", api.deleteBandwidthRateLimit)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.wrap)
      .provideEnvironment(r)
    def listTapes(
        request: zio.aws.storagegateway.model.ListTapesRequest
    ): ZStream[Any, AwsError, zio.aws.storagegateway.model.TapeInfo.ReadOnly] =
      asyncJavaPaginatedRequest[ListTapesRequest, TapeInfo, ListTapesPublisher](
        "listTapes",
        api.listTapesPaginator,
        _.tapeInfos()
      )(request.buildAwsValue())
        .map(item => zio.aws.storagegateway.model.TapeInfo.wrap(item))
        .provideEnvironment(r)
    def listTapesPaginated(
        request: zio.aws.storagegateway.model.ListTapesRequest
    ): IO[AwsError, zio.aws.storagegateway.model.ListTapesResponse.ReadOnly] =
      asyncRequestResponse[ListTapesRequest, ListTapesResponse](
        "listTapes",
        api.listTapes
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.ListTapesResponse.wrap)
        .provideEnvironment(r)
    def describeTapeArchives(
        request: zio.aws.storagegateway.model.DescribeTapeArchivesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.storagegateway.model.TapeArchive.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeTapeArchivesRequest,
      TapeArchive,
      DescribeTapeArchivesPublisher
    ](
      "describeTapeArchives",
      api.describeTapeArchivesPaginator,
      _.tapeArchives()
    )(request.buildAwsValue())
      .map(item => zio.aws.storagegateway.model.TapeArchive.wrap(item))
      .provideEnvironment(r)
    def describeTapeArchivesPaginated(
        request: zio.aws.storagegateway.model.DescribeTapeArchivesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeTapeArchivesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTapeArchivesRequest,
      DescribeTapeArchivesResponse
    ]("describeTapeArchives", api.describeTapeArchives)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DescribeTapeArchivesResponse.wrap)
      .provideEnvironment(r)
    def describeFileSystemAssociations(
        request: zio.aws.storagegateway.model.DescribeFileSystemAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFileSystemAssociationsRequest,
      DescribeFileSystemAssociationsResponse
    ]("describeFileSystemAssociations", api.describeFileSystemAssociations)(
      request.buildAwsValue()
    ).map(
      zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.wrap
    ).provideEnvironment(r)
    def describeWorkingStorage(
        request: zio.aws.storagegateway.model.DescribeWorkingStorageRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeWorkingStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeWorkingStorageRequest,
      DescribeWorkingStorageResponse
    ]("describeWorkingStorage", api.describeWorkingStorage)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeWorkingStorageResponse.wrap)
      .provideEnvironment(r)
    def updateSMBSecurityStrategy(
        request: zio.aws.storagegateway.model.UpdateSmbSecurityStrategyRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateSmbSecurityStrategyResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSmbSecurityStrategyRequest,
      UpdateSmbSecurityStrategyResponse
    ]("updateSMBSecurityStrategy", api.updateSMBSecurityStrategy)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.UpdateSmbSecurityStrategyResponse.wrap)
      .provideEnvironment(r)
    def listLocalDisks(
        request: zio.aws.storagegateway.model.ListLocalDisksRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListLocalDisksResponse.ReadOnly
    ] = asyncRequestResponse[ListLocalDisksRequest, ListLocalDisksResponse](
      "listLocalDisks",
      api.listLocalDisks
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.ListLocalDisksResponse.wrap)
      .provideEnvironment(r)
    def deleteTapePool(
        request: zio.aws.storagegateway.model.DeleteTapePoolRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly
    ] = asyncRequestResponse[DeleteTapePoolRequest, DeleteTapePoolResponse](
      "deleteTapePool",
      api.deleteTapePool
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DeleteTapePoolResponse.wrap)
      .provideEnvironment(r)
    def describeBandwidthRateLimit(
        request: zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeBandwidthRateLimitRequest,
      DescribeBandwidthRateLimitResponse
    ]("describeBandwidthRateLimit", api.describeBandwidthRateLimit)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.wrap)
      .provideEnvironment(r)
    def updateSMBFileShare(
        request: zio.aws.storagegateway.model.UpdateSmbFileShareRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateSmbFileShareResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSmbFileShareRequest,
      UpdateSmbFileShareResponse
    ]("updateSMBFileShare", api.updateSMBFileShare)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.UpdateSmbFileShareResponse.wrap)
      .provideEnvironment(r)
    def retrieveTapeRecoveryPoint(
        request: zio.aws.storagegateway.model.RetrieveTapeRecoveryPointRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.ReadOnly
    ] = asyncRequestResponse[
      RetrieveTapeRecoveryPointRequest,
      RetrieveTapeRecoveryPointResponse
    ]("retrieveTapeRecoveryPoint", api.retrieveTapeRecoveryPoint)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.wrap)
      .provideEnvironment(r)
    def createSnapshotFromVolumeRecoveryPoint(
        request: zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSnapshotFromVolumeRecoveryPointRequest,
      CreateSnapshotFromVolumeRecoveryPointResponse
    ](
      "createSnapshotFromVolumeRecoveryPoint",
      api.createSnapshotFromVolumeRecoveryPoint
    )(request.buildAwsValue())
      .map(
        zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.wrap
      )
      .provideEnvironment(r)
    def createCachediSCSIVolume(
        request: zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCachediScsiVolumeRequest,
      CreateCachediScsiVolumeResponse
    ]("createCachediSCSIVolume", api.createCachediSCSIVolume)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.storagegateway.model.ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.storagegateway.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListTagsForResourceRequest,
        Tag,
        ListTagsForResourcePublisher
      ]("listTagsForResource", api.listTagsForResourcePaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.storagegateway.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.storagegateway.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeNFSFileShares(
        request: zio.aws.storagegateway.model.DescribeNfsFileSharesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNfsFileSharesRequest,
      DescribeNfsFileSharesResponse
    ]("describeNFSFileShares", api.describeNFSFileShares)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.wrap)
      .provideEnvironment(r)
    def deleteVolume(
        request: zio.aws.storagegateway.model.DeleteVolumeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteVolumeResponse.ReadOnly
    ] = asyncRequestResponse[DeleteVolumeRequest, DeleteVolumeResponse](
      "deleteVolume",
      api.deleteVolume
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DeleteVolumeResponse.wrap)
      .provideEnvironment(r)
    def updateChapCredentials(
        request: zio.aws.storagegateway.model.UpdateChapCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateChapCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateChapCredentialsRequest,
      UpdateChapCredentialsResponse
    ]("updateChapCredentials", api.updateChapCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.UpdateChapCredentialsResponse.wrap)
      .provideEnvironment(r)
    def notifyWhenUploaded(
        request: zio.aws.storagegateway.model.NotifyWhenUploadedRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.NotifyWhenUploadedResponse.ReadOnly
    ] = asyncRequestResponse[
      NotifyWhenUploadedRequest,
      NotifyWhenUploadedResponse
    ]("notifyWhenUploaded", api.notifyWhenUploaded)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.NotifyWhenUploadedResponse.wrap)
      .provideEnvironment(r)
    def resetCache(
        request: zio.aws.storagegateway.model.ResetCacheRequest
    ): IO[AwsError, zio.aws.storagegateway.model.ResetCacheResponse.ReadOnly] =
      asyncRequestResponse[ResetCacheRequest, ResetCacheResponse](
        "resetCache",
        api.resetCache
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.ResetCacheResponse.wrap)
        .provideEnvironment(r)
    def updateGatewaySoftwareNow(
        request: zio.aws.storagegateway.model.UpdateGatewaySoftwareNowRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGatewaySoftwareNowRequest,
      UpdateGatewaySoftwareNowResponse
    ]("updateGatewaySoftwareNow", api.updateGatewaySoftwareNow)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.wrap)
      .provideEnvironment(r)
    def associateFileSystem(
        request: zio.aws.storagegateway.model.AssociateFileSystemRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateFileSystemRequest,
      AssociateFileSystemResponse
    ]("associateFileSystem", api.associateFileSystem)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.AssociateFileSystemResponse.wrap)
      .provideEnvironment(r)
    def setLocalConsolePassword(
        request: zio.aws.storagegateway.model.SetLocalConsolePasswordRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      SetLocalConsolePasswordRequest,
      SetLocalConsolePasswordResponse
    ]("setLocalConsolePassword", api.setLocalConsolePassword)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.wrap)
      .provideEnvironment(r)
    def deleteAutomaticTapeCreationPolicy(
        request: zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAutomaticTapeCreationPolicyRequest,
      DeleteAutomaticTapeCreationPolicyResponse
    ](
      "deleteAutomaticTapeCreationPolicy",
      api.deleteAutomaticTapeCreationPolicy
    )(request.buildAwsValue())
      .map(
        zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.wrap
      )
      .provideEnvironment(r)
    def addUploadBuffer(
        request: zio.aws.storagegateway.model.AddUploadBufferRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.AddUploadBufferResponse.ReadOnly
    ] = asyncRequestResponse[AddUploadBufferRequest, AddUploadBufferResponse](
      "addUploadBuffer",
      api.addUploadBuffer
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.AddUploadBufferResponse.wrap)
      .provideEnvironment(r)
    def describeGatewayInformation(
        request: zio.aws.storagegateway.model.DescribeGatewayInformationRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGatewayInformationRequest,
      DescribeGatewayInformationResponse
    ]("describeGatewayInformation", api.describeGatewayInformation)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeGatewayInformationResponse.wrap)
      .provideEnvironment(r)
    def updateNFSFileShare(
        request: zio.aws.storagegateway.model.UpdateNfsFileShareRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateNfsFileShareResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateNfsFileShareRequest,
      UpdateNfsFileShareResponse
    ]("updateNFSFileShare", api.updateNFSFileShare)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.UpdateNfsFileShareResponse.wrap)
      .provideEnvironment(r)
    def deleteTapeArchive(
        request: zio.aws.storagegateway.model.DeleteTapeArchiveRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DeleteTapeArchiveResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteTapeArchiveRequest, DeleteTapeArchiveResponse](
        "deleteTapeArchive",
        api.deleteTapeArchive
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.DeleteTapeArchiveResponse.wrap)
        .provideEnvironment(r)
    def updateSnapshotSchedule(
        request: zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSnapshotScheduleRequest,
      UpdateSnapshotScheduleResponse
    ]("updateSnapshotSchedule", api.updateSnapshotSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.wrap)
      .provideEnvironment(r)
    def createTapePool(
        request: zio.aws.storagegateway.model.CreateTapePoolRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CreateTapePoolResponse.ReadOnly
    ] = asyncRequestResponse[CreateTapePoolRequest, CreateTapePoolResponse](
      "createTapePool",
      api.createTapePool
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.CreateTapePoolResponse.wrap)
      .provideEnvironment(r)
    def createStorediSCSIVolume(
        request: zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateStorediScsiVolumeRequest,
      CreateStorediScsiVolumeResponse
    ]("createStorediSCSIVolume", api.createStorediSCSIVolume)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.wrap)
      .provideEnvironment(r)
    def listVolumeRecoveryPoints(
        request: zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVolumeRecoveryPointsRequest,
      ListVolumeRecoveryPointsResponse
    ]("listVolumeRecoveryPoints", api.listVolumeRecoveryPoints)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.wrap)
      .provideEnvironment(r)
    def updateVTLDeviceType(
        request: zio.aws.storagegateway.model.UpdateVtlDeviceTypeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateVtlDeviceTypeRequest,
      UpdateVtlDeviceTypeResponse
    ]("updateVTLDeviceType", api.updateVTLDeviceType)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.wrap)
      .provideEnvironment(r)
    def updateSMBFileShareVisibility(
        request: zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSmbFileShareVisibilityRequest,
      UpdateSmbFileShareVisibilityResponse
    ]("updateSMBFileShareVisibility", api.updateSMBFileShareVisibility)(
      request.buildAwsValue()
    ).map(
      zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityResponse.wrap
    ).provideEnvironment(r)
    def describeVTLDevices(
        request: zio.aws.storagegateway.model.DescribeVtlDevicesRequest
    ): ZStream[Any, AwsError, zio.aws.storagegateway.model.VTLDevice.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeVtlDevicesRequest,
        VTLDevice,
        DescribeVTLDevicesPublisher
      ]("describeVTLDevices", api.describeVTLDevicesPaginator, _.vtlDevices())(
        request.buildAwsValue()
      ).map(item => zio.aws.storagegateway.model.VTLDevice.wrap(item))
        .provideEnvironment(r)
    def describeVTLDevicesPaginated(
        request: zio.aws.storagegateway.model.DescribeVtlDevicesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVtlDevicesRequest,
      DescribeVtlDevicesResponse
    ]("describeVTLDevices", api.describeVTLDevices)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DescribeVtlDevicesResponse.wrap)
      .provideEnvironment(r)
    def listTapePools(
        request: zio.aws.storagegateway.model.ListTapePoolsRequest
    ): ZStream[Any, AwsError, zio.aws.storagegateway.model.PoolInfo.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListTapePoolsRequest,
        PoolInfo,
        ListTapePoolsPublisher
      ]("listTapePools", api.listTapePoolsPaginator, _.poolInfos())(
        request.buildAwsValue()
      ).map(item => zio.aws.storagegateway.model.PoolInfo.wrap(item))
        .provideEnvironment(r)
    def listTapePoolsPaginated(
        request: zio.aws.storagegateway.model.ListTapePoolsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListTapePoolsResponse.ReadOnly
    ] = asyncRequestResponse[ListTapePoolsRequest, ListTapePoolsResponse](
      "listTapePools",
      api.listTapePools
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.ListTapePoolsResponse.wrap)
      .provideEnvironment(r)
    def disableGateway(
        request: zio.aws.storagegateway.model.DisableGatewayRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DisableGatewayResponse.ReadOnly
    ] = asyncRequestResponse[DisableGatewayRequest, DisableGatewayResponse](
      "disableGateway",
      api.disableGateway
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DisableGatewayResponse.wrap)
      .provideEnvironment(r)
    def createTapes(
        request: zio.aws.storagegateway.model.CreateTapesRequest
    ): IO[AwsError, zio.aws.storagegateway.model.CreateTapesResponse.ReadOnly] =
      asyncRequestResponse[CreateTapesRequest, CreateTapesResponse](
        "createTapes",
        api.createTapes
      )(request.buildAwsValue())
        .map(zio.aws.storagegateway.model.CreateTapesResponse.wrap)
        .provideEnvironment(r)
    def updateFileSystemAssociation(
        request: zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFileSystemAssociationRequest,
      UpdateFileSystemAssociationResponse
    ]("updateFileSystemAssociation", api.updateFileSystemAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.wrap)
      .provideEnvironment(r)
    def describeTapeRecoveryPoints(
        request: zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeTapeRecoveryPointsRequest,
      TapeRecoveryPointInfo,
      DescribeTapeRecoveryPointsPublisher
    ](
      "describeTapeRecoveryPoints",
      api.describeTapeRecoveryPointsPaginator,
      _.tapeRecoveryPointInfos()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.storagegateway.model.TapeRecoveryPointInfo.wrap(item)
      )
      .provideEnvironment(r)
    def describeTapeRecoveryPointsPaginated(
        request: zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTapeRecoveryPointsRequest,
      DescribeTapeRecoveryPointsResponse
    ]("describeTapeRecoveryPoints", api.describeTapeRecoveryPoints)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.wrap)
      .provideEnvironment(r)
    def cancelRetrieval(
        request: zio.aws.storagegateway.model.CancelRetrievalRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CancelRetrievalResponse.ReadOnly
    ] = asyncRequestResponse[CancelRetrievalRequest, CancelRetrievalResponse](
      "cancelRetrieval",
      api.cancelRetrieval
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.CancelRetrievalResponse.wrap)
      .provideEnvironment(r)
    def createTapeWithBarcode(
        request: zio.aws.storagegateway.model.CreateTapeWithBarcodeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CreateTapeWithBarcodeResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTapeWithBarcodeRequest,
      CreateTapeWithBarcodeResponse
    ]("createTapeWithBarcode", api.createTapeWithBarcode)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.CreateTapeWithBarcodeResponse.wrap)
      .provideEnvironment(r)
    def describeSMBFileShares(
        request: zio.aws.storagegateway.model.DescribeSmbFileSharesRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSmbFileSharesRequest,
      DescribeSmbFileSharesResponse
    ]("describeSMBFileShares", api.describeSMBFileShares)(
      request.buildAwsValue()
    ).map(zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.wrap)
      .provideEnvironment(r)
    def detachVolume(
        request: zio.aws.storagegateway.model.DetachVolumeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DetachVolumeResponse.ReadOnly
    ] = asyncRequestResponse[DetachVolumeRequest, DetachVolumeResponse](
      "detachVolume",
      api.detachVolume
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.DetachVolumeResponse.wrap)
      .provideEnvironment(r)
    def createSnapshot(
        request: zio.aws.storagegateway.model.CreateSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.CreateSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[CreateSnapshotRequest, CreateSnapshotResponse](
      "createSnapshot",
      api.createSnapshot
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.CreateSnapshotResponse.wrap)
      .provideEnvironment(r)
    def updateSMBLocalGroups(
        request: zio.aws.storagegateway.model.UpdateSmbLocalGroupsRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSmbLocalGroupsRequest,
      UpdateSmbLocalGroupsResponse
    ]("updateSMBLocalGroups", api.updateSMBLocalGroups)(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.wrap)
      .provideEnvironment(r)
    def listGateways(
        request: zio.aws.storagegateway.model.ListGatewaysRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      ListGatewaysRequest,
      GatewayInfo,
      ListGatewaysPublisher
    ]("listGateways", api.listGatewaysPaginator, _.gateways())(
      request.buildAwsValue()
    ).map(item => zio.aws.storagegateway.model.GatewayInfo.wrap(item))
      .provideEnvironment(r)
    def listGatewaysPaginated(
        request: zio.aws.storagegateway.model.ListGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.ListGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[ListGatewaysRequest, ListGatewaysResponse](
      "listGateways",
      api.listGateways
    )(request.buildAwsValue())
      .map(zio.aws.storagegateway.model.ListGatewaysResponse.wrap)
      .provideEnvironment(r)
    def describeMaintenanceStartTime(
        request: zio.aws.storagegateway.model.DescribeMaintenanceStartTimeRequest
    ): IO[
      AwsError,
      zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceStartTimeRequest,
      DescribeMaintenanceStartTimeResponse
    ]("describeMaintenanceStartTime", api.describeMaintenanceStartTime)(
      request.buildAwsValue()
    ).map(
      zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.wrap
    ).provideEnvironment(r)
  }
  def listAutomaticTapeCreationPolicies(
      request: zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAutomaticTapeCreationPolicies(request))
  def addTagsToResource(
      request: zio.aws.storagegateway.model.AddTagsToResourceRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.AddTagsToResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTagsToResource(request))
  def createSMBFileShare(
      request: zio.aws.storagegateway.model.CreateSmbFileShareRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateSmbFileShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSMBFileShare(request))
  def listVolumeInitiators(
      request: zio.aws.storagegateway.model.ListVolumeInitiatorsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListVolumeInitiatorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVolumeInitiators(request))
  def joinDomain(request: zio.aws.storagegateway.model.JoinDomainRequest): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.JoinDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.joinDomain(request))
  def listVolumes(
      request: zio.aws.storagegateway.model.ListVolumesRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.VolumeInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listVolumes(request))
  def listVolumesPaginated(
      request: zio.aws.storagegateway.model.ListVolumesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListVolumesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVolumesPaginated(request))
  def describeAvailabilityMonitorTest(
      request: zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAvailabilityMonitorTest(request))
  def describeChapCredentials(
      request: zio.aws.storagegateway.model.DescribeChapCredentialsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeChapCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChapCredentials(request))
  def retrieveTapeArchive(
      request: zio.aws.storagegateway.model.RetrieveTapeArchiveRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.RetrieveTapeArchiveResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retrieveTapeArchive(request))
  def updateBandwidthRateLimitSchedule(
      request: zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBandwidthRateLimitSchedule(request))
  def deleteFileShare(
      request: zio.aws.storagegateway.model.DeleteFileShareRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteFileShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFileShare(request))
  def describeCachediSCSIVolumes(
      request: zio.aws.storagegateway.model.DescribeCachediScsiVolumesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCachediSCSIVolumes(request))
  def updateGatewayInformation(
      request: zio.aws.storagegateway.model.UpdateGatewayInformationRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateGatewayInformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGatewayInformation(request))
  def deleteTape(request: zio.aws.storagegateway.model.DeleteTapeRequest): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteTapeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTape(request))
  def updateMaintenanceStartTime(
      request: zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateMaintenanceStartTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMaintenanceStartTime(request))
  def deleteGateway(
      request: zio.aws.storagegateway.model.DeleteGatewayRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGateway(request))
  def describeTapes(
      request: zio.aws.storagegateway.model.DescribeTapesRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.Tape.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTapes(request))
  def describeTapesPaginated(
      request: zio.aws.storagegateway.model.DescribeTapesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeTapesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTapesPaginated(request))
  def refreshCache(
      request: zio.aws.storagegateway.model.RefreshCacheRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.RefreshCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.refreshCache(request))
  def describeSMBSettings(
      request: zio.aws.storagegateway.model.DescribeSmbSettingsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSMBSettings(request))
  def deleteChapCredentials(
      request: zio.aws.storagegateway.model.DeleteChapCredentialsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteChapCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChapCredentials(request))
  def listFileSystemAssociations(
      request: zio.aws.storagegateway.model.ListFileSystemAssociationsRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.FileSystemAssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFileSystemAssociations(request))
  def listFileSystemAssociationsPaginated(
      request: zio.aws.storagegateway.model.ListFileSystemAssociationsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListFileSystemAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFileSystemAssociationsPaginated(request))
  def shutdownGateway(
      request: zio.aws.storagegateway.model.ShutdownGatewayRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ShutdownGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.shutdownGateway(request))
  def updateBandwidthRateLimit(
      request: zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateBandwidthRateLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBandwidthRateLimit(request))
  def deleteSnapshotSchedule(
      request: zio.aws.storagegateway.model.DeleteSnapshotScheduleRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteSnapshotScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSnapshotSchedule(request))
  def setSMBGuestPassword(
      request: zio.aws.storagegateway.model.SetSmbGuestPasswordRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setSMBGuestPassword(request))
  def removeTagsFromResource(
      request: zio.aws.storagegateway.model.RemoveTagsFromResourceRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.RemoveTagsFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def describeStorediSCSIVolumes(
      request: zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeStorediScsiVolumesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStorediSCSIVolumes(request))
  def describeCache(
      request: zio.aws.storagegateway.model.DescribeCacheRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCache(request))
  def assignTapePool(
      request: zio.aws.storagegateway.model.AssignTapePoolRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.AssignTapePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assignTapePool(request))
  def startAvailabilityMonitorTest(
      request: zio.aws.storagegateway.model.StartAvailabilityMonitorTestRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAvailabilityMonitorTest(request))
  def startGateway(
      request: zio.aws.storagegateway.model.StartGatewayRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.StartGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startGateway(request))
  def addCache(request: zio.aws.storagegateway.model.AddCacheRequest): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.AddCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addCache(request))
  def createNFSFileShare(
      request: zio.aws.storagegateway.model.CreateNfsFileShareRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateNfsFileShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNFSFileShare(request))
  def activateGateway(
      request: zio.aws.storagegateway.model.ActivateGatewayRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ActivateGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.activateGateway(request))
  def listFileShares(
      request: zio.aws.storagegateway.model.ListFileSharesRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.FileShareInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listFileShares(request))
  def listFileSharesPaginated(
      request: zio.aws.storagegateway.model.ListFileSharesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFileSharesPaginated(request))
  def addWorkingStorage(
      request: zio.aws.storagegateway.model.AddWorkingStorageRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.AddWorkingStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addWorkingStorage(request))
  def updateAutomaticTapeCreationPolicy(
      request: zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAutomaticTapeCreationPolicy(request))
  def disassociateFileSystem(
      request: zio.aws.storagegateway.model.DisassociateFileSystemRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DisassociateFileSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateFileSystem(request))
  def cancelArchival(
      request: zio.aws.storagegateway.model.CancelArchivalRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CancelArchivalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelArchival(request))
  def describeUploadBuffer(
      request: zio.aws.storagegateway.model.DescribeUploadBufferRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeUploadBufferResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUploadBuffer(request))
  def describeBandwidthRateLimitSchedule(
      request: zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBandwidthRateLimitSchedule(request))
  def attachVolume(
      request: zio.aws.storagegateway.model.AttachVolumeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.AttachVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachVolume(request))
  def describeSnapshotSchedule(
      request: zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeSnapshotScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSnapshotSchedule(request))
  def deleteBandwidthRateLimit(
      request: zio.aws.storagegateway.model.DeleteBandwidthRateLimitRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBandwidthRateLimit(request))
  def listTapes(
      request: zio.aws.storagegateway.model.ListTapesRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.TapeInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listTapes(request))
  def listTapesPaginated(
      request: zio.aws.storagegateway.model.ListTapesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListTapesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTapesPaginated(request))
  def describeTapeArchives(
      request: zio.aws.storagegateway.model.DescribeTapeArchivesRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.TapeArchive.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTapeArchives(request))
  def describeTapeArchivesPaginated(
      request: zio.aws.storagegateway.model.DescribeTapeArchivesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeTapeArchivesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTapeArchivesPaginated(request))
  def describeFileSystemAssociations(
      request: zio.aws.storagegateway.model.DescribeFileSystemAssociationsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFileSystemAssociations(request))
  def describeWorkingStorage(
      request: zio.aws.storagegateway.model.DescribeWorkingStorageRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeWorkingStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkingStorage(request))
  def updateSMBSecurityStrategy(
      request: zio.aws.storagegateway.model.UpdateSmbSecurityStrategyRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateSmbSecurityStrategyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSMBSecurityStrategy(request))
  def listLocalDisks(
      request: zio.aws.storagegateway.model.ListLocalDisksRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListLocalDisksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLocalDisks(request))
  def deleteTapePool(
      request: zio.aws.storagegateway.model.DeleteTapePoolRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTapePool(request))
  def describeBandwidthRateLimit(
      request: zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeBandwidthRateLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBandwidthRateLimit(request))
  def updateSMBFileShare(
      request: zio.aws.storagegateway.model.UpdateSmbFileShareRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateSmbFileShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSMBFileShare(request))
  def retrieveTapeRecoveryPoint(
      request: zio.aws.storagegateway.model.RetrieveTapeRecoveryPointRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retrieveTapeRecoveryPoint(request))
  def createSnapshotFromVolumeRecoveryPoint(
      request: zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshotFromVolumeRecoveryPoint(request))
  def createCachediSCSIVolume(
      request: zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCachediSCSIVolume(request))
  def listTagsForResource(
      request: zio.aws.storagegateway.model.ListTagsForResourceRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.storagegateway.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def describeNFSFileShares(
      request: zio.aws.storagegateway.model.DescribeNfsFileSharesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNFSFileShares(request))
  def deleteVolume(
      request: zio.aws.storagegateway.model.DeleteVolumeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVolume(request))
  def updateChapCredentials(
      request: zio.aws.storagegateway.model.UpdateChapCredentialsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateChapCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChapCredentials(request))
  def notifyWhenUploaded(
      request: zio.aws.storagegateway.model.NotifyWhenUploadedRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.NotifyWhenUploadedResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyWhenUploaded(request))
  def resetCache(request: zio.aws.storagegateway.model.ResetCacheRequest): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ResetCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetCache(request))
  def updateGatewaySoftwareNow(
      request: zio.aws.storagegateway.model.UpdateGatewaySoftwareNowRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGatewaySoftwareNow(request))
  def associateFileSystem(
      request: zio.aws.storagegateway.model.AssociateFileSystemRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateFileSystem(request))
  def setLocalConsolePassword(
      request: zio.aws.storagegateway.model.SetLocalConsolePasswordRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setLocalConsolePassword(request))
  def deleteAutomaticTapeCreationPolicy(
      request: zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAutomaticTapeCreationPolicy(request))
  def addUploadBuffer(
      request: zio.aws.storagegateway.model.AddUploadBufferRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.AddUploadBufferResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addUploadBuffer(request))
  def describeGatewayInformation(
      request: zio.aws.storagegateway.model.DescribeGatewayInformationRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGatewayInformation(request))
  def updateNFSFileShare(
      request: zio.aws.storagegateway.model.UpdateNfsFileShareRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateNfsFileShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNFSFileShare(request))
  def deleteTapeArchive(
      request: zio.aws.storagegateway.model.DeleteTapeArchiveRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DeleteTapeArchiveResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTapeArchive(request))
  def updateSnapshotSchedule(
      request: zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSnapshotSchedule(request))
  def createTapePool(
      request: zio.aws.storagegateway.model.CreateTapePoolRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateTapePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTapePool(request))
  def createStorediSCSIVolume(
      request: zio.aws.storagegateway.model.CreateStorediScsiVolumeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStorediSCSIVolume(request))
  def listVolumeRecoveryPoints(
      request: zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVolumeRecoveryPoints(request))
  def updateVTLDeviceType(
      request: zio.aws.storagegateway.model.UpdateVtlDeviceTypeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVTLDeviceType(request))
  def updateSMBFileShareVisibility(
      request: zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateSmbFileShareVisibilityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSMBFileShareVisibility(request))
  def describeVTLDevices(
      request: zio.aws.storagegateway.model.DescribeVtlDevicesRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.VTLDevice.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVTLDevices(request))
  def describeVTLDevicesPaginated(
      request: zio.aws.storagegateway.model.DescribeVtlDevicesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeVtlDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVTLDevicesPaginated(request))
  def listTapePools(
      request: zio.aws.storagegateway.model.ListTapePoolsRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.PoolInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listTapePools(request))
  def listTapePoolsPaginated(
      request: zio.aws.storagegateway.model.ListTapePoolsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListTapePoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTapePoolsPaginated(request))
  def disableGateway(
      request: zio.aws.storagegateway.model.DisableGatewayRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DisableGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableGateway(request))
  def createTapes(
      request: zio.aws.storagegateway.model.CreateTapesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateTapesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTapes(request))
  def updateFileSystemAssociation(
      request: zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFileSystemAssociation(request))
  def describeTapeRecoveryPoints(
      request: zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ): ZStream[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTapeRecoveryPoints(request))
  def describeTapeRecoveryPointsPaginated(
      request: zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTapeRecoveryPointsPaginated(request))
  def cancelRetrieval(
      request: zio.aws.storagegateway.model.CancelRetrievalRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CancelRetrievalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelRetrieval(request))
  def createTapeWithBarcode(
      request: zio.aws.storagegateway.model.CreateTapeWithBarcodeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateTapeWithBarcodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTapeWithBarcode(request))
  def describeSMBFileShares(
      request: zio.aws.storagegateway.model.DescribeSmbFileSharesRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeSmbFileSharesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSMBFileShares(request))
  def detachVolume(
      request: zio.aws.storagegateway.model.DetachVolumeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DetachVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachVolume(request))
  def createSnapshot(
      request: zio.aws.storagegateway.model.CreateSnapshotRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.CreateSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshot(request))
  def updateSMBLocalGroups(
      request: zio.aws.storagegateway.model.UpdateSmbLocalGroupsRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSMBLocalGroups(request))
  def listGateways(
      request: zio.aws.storagegateway.model.ListGatewaysRequest
  ): ZStream[zio.aws.storagegateway.StorageGateway, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listGateways(request))
  def listGatewaysPaginated(
      request: zio.aws.storagegateway.model.ListGatewaysRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.ListGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGatewaysPaginated(request))
  def describeMaintenanceStartTime(
      request: zio.aws.storagegateway.model.DescribeMaintenanceStartTimeRequest
  ): ZIO[
    zio.aws.storagegateway.StorageGateway,
    AwsError,
    zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMaintenanceStartTime(request))
}
