package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateBandwidthRateLimitScheduleRequest(
    gatewayARN: GatewayARN,
    bandwidthRateLimitIntervals: Iterable[
      zio.aws.storagegateway.model.BandwidthRateLimitInterval
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest = {
    import UpdateBandwidthRateLimitScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .bandwidthRateLimitIntervals(bandwidthRateLimitIntervals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
      .wrap(buildAwsValue())
}
object UpdateBandwidthRateLimitScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest =
      zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest(
        gatewayARN,
        bandwidthRateLimitIntervals.map { item =>
          item.asEditable
        }
      )
    def gatewayARN: GatewayARN
    def bandwidthRateLimitIntervals
        : List[zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getBandwidthRateLimitIntervals: ZIO[Any, Nothing, List[
      zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly
    ]] = ZIO.succeed(bandwidthRateLimitIntervals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
  ) extends zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val bandwidthRateLimitIntervals: List[
      zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly
    ] = impl
      .bandwidthRateLimitIntervals()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.BandwidthRateLimitInterval.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
  ): zio.aws.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
