package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetachVolumeResponse(volumeARN: Option[VolumeARN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DetachVolumeResponse = {
    import DetachVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DetachVolumeResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DetachVolumeResponse.ReadOnly =
    zio.aws.storagegateway.model.DetachVolumeResponse.wrap(buildAwsValue())
}
object DetachVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DetachVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DetachVolumeResponse =
      zio.aws.storagegateway.model
        .DetachVolumeResponse(volumeARN.map(value => value))
    def volumeARN: Option[VolumeARN]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DetachVolumeResponse
  ) extends zio.aws.storagegateway.model.DetachVolumeResponse.ReadOnly {
    override val volumeARN: Option[VolumeARN] = scala
      .Option(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DetachVolumeResponse
  ): zio.aws.storagegateway.model.DetachVolumeResponse.ReadOnly = new Wrapper(
    impl
  )
}
