package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVolumeRequest(volumeARN: VolumeARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteVolumeRequest = {
    import DeleteVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteVolumeRequest
      .builder()
      .volumeARN(VolumeARN.unwrap(volumeARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DeleteVolumeRequest.ReadOnly =
    zio.aws.storagegateway.model.DeleteVolumeRequest.wrap(buildAwsValue())
}
object DeleteVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteVolumeRequest =
      zio.aws.storagegateway.model.DeleteVolumeRequest(volumeARN)
    def volumeARN: VolumeARN
    def getVolumeARN: ZIO[Any, Nothing, VolumeARN] = ZIO.succeed(volumeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteVolumeRequest
  ) extends zio.aws.storagegateway.model.DeleteVolumeRequest.ReadOnly {
    override val volumeARN: VolumeARN =
      zio.aws.storagegateway.model.primitives.VolumeARN(impl.volumeARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteVolumeRequest
  ): zio.aws.storagegateway.model.DeleteVolumeRequest.ReadOnly = new Wrapper(
    impl
  )
}
