package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  PoolARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTapePoolsRequest(
    poolARNs: Option[Iterable[PoolARN]] = None,
    marker: Option[Marker] = None,
    limit: Option[PositiveIntObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest = {
    import ListTapePoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest
      .builder()
      .optionallyWith(
        poolARNs.map(value =>
          value.map { item =>
            PoolARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.poolARNs)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListTapePoolsRequest.ReadOnly =
    zio.aws.storagegateway.model.ListTapePoolsRequest.wrap(buildAwsValue())
}
object ListTapePoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListTapePoolsRequest =
      zio.aws.storagegateway.model.ListTapePoolsRequest(
        poolARNs.map(value => value),
        marker.map(value => value),
        limit.map(value => value)
      )
    def poolARNs: Option[List[PoolARN]]
    def marker: Option[Marker]
    def limit: Option[PositiveIntObject]
    def getPoolARNs: ZIO[Any, AwsError, List[PoolARN]] =
      AwsError.unwrapOptionField("poolARNs", poolARNs)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest
  ) extends zio.aws.storagegateway.model.ListTapePoolsRequest.ReadOnly {
    override val poolARNs: Option[List[PoolARN]] = scala
      .Option(impl.poolARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.PoolARN(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Option[PositiveIntObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest
  ): zio.aws.storagegateway.model.ListTapePoolsRequest.ReadOnly = new Wrapper(
    impl
  )
}
