package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  BandwidthDownloadRateLimit,
  BandwidthUploadRateLimit,
  GatewayARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateBandwidthRateLimitRequest(
    gatewayARN: GatewayARN,
    averageUploadRateLimitInBitsPerSec: Option[BandwidthUploadRateLimit] = None,
    averageDownloadRateLimitInBitsPerSec: Option[BandwidthDownloadRateLimit] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitRequest = {
    import UpdateBandwidthRateLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .optionallyWith(
        averageUploadRateLimitInBitsPerSec.map(value =>
          BandwidthUploadRateLimit.unwrap(value): java.lang.Long
        )
      )(_.averageUploadRateLimitInBitsPerSec)
      .optionallyWith(
        averageDownloadRateLimitInBitsPerSec.map(value =>
          BandwidthDownloadRateLimit.unwrap(value): java.lang.Long
        )
      )(_.averageDownloadRateLimitInBitsPerSec)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest
      .wrap(buildAwsValue())
}
object UpdateBandwidthRateLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest =
      zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest(
        gatewayARN,
        averageUploadRateLimitInBitsPerSec.map(value => value),
        averageDownloadRateLimitInBitsPerSec.map(value => value)
      )
    def gatewayARN: GatewayARN
    def averageUploadRateLimitInBitsPerSec: Option[BandwidthUploadRateLimit]
    def averageDownloadRateLimitInBitsPerSec: Option[BandwidthDownloadRateLimit]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getAverageUploadRateLimitInBitsPerSec
        : ZIO[Any, AwsError, BandwidthUploadRateLimit] =
      AwsError.unwrapOptionField(
        "averageUploadRateLimitInBitsPerSec",
        averageUploadRateLimitInBitsPerSec
      )
    def getAverageDownloadRateLimitInBitsPerSec
        : ZIO[Any, AwsError, BandwidthDownloadRateLimit] =
      AwsError.unwrapOptionField(
        "averageDownloadRateLimitInBitsPerSec",
        averageDownloadRateLimitInBitsPerSec
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitRequest
  ) extends zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val averageUploadRateLimitInBitsPerSec
        : Option[BandwidthUploadRateLimit] = scala
      .Option(impl.averageUploadRateLimitInBitsPerSec())
      .map(value =>
        zio.aws.storagegateway.model.primitives.BandwidthUploadRateLimit(value)
      )
    override val averageDownloadRateLimitInBitsPerSec
        : Option[BandwidthDownloadRateLimit] = scala
      .Option(impl.averageDownloadRateLimitInBitsPerSec())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .BandwidthDownloadRateLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitRequest
  ): zio.aws.storagegateway.model.UpdateBandwidthRateLimitRequest.ReadOnly =
    new Wrapper(impl)
}
