package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  TapeRecoveryPointStatus,
  TapeSize,
  Time,
  TapeARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TapeRecoveryPointInfo(
    tapeARN: Option[TapeARN] = None,
    tapeRecoveryPointTime: Option[Time] = None,
    tapeSizeInBytes: Option[TapeSize] = None,
    tapeStatus: Option[TapeRecoveryPointStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo = {
    import TapeRecoveryPointInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .optionallyWith(
        tapeRecoveryPointTime.map(value => Time.unwrap(value): Instant)
      )(_.tapeRecoveryPointTime)
      .optionallyWith(
        tapeSizeInBytes.map(value => TapeSize.unwrap(value): java.lang.Long)
      )(_.tapeSizeInBytes)
      .optionallyWith(
        tapeStatus.map(value =>
          TapeRecoveryPointStatus.unwrap(value): java.lang.String
        )
      )(_.tapeStatus)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly =
    zio.aws.storagegateway.model.TapeRecoveryPointInfo.wrap(buildAwsValue())
}
object TapeRecoveryPointInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.TapeRecoveryPointInfo =
      zio.aws.storagegateway.model.TapeRecoveryPointInfo(
        tapeARN.map(value => value),
        tapeRecoveryPointTime.map(value => value),
        tapeSizeInBytes.map(value => value),
        tapeStatus.map(value => value)
      )
    def tapeARN: Option[TapeARN]
    def tapeRecoveryPointTime: Option[Time]
    def tapeSizeInBytes: Option[TapeSize]
    def tapeStatus: Option[TapeRecoveryPointStatus]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
    def getTapeRecoveryPointTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("tapeRecoveryPointTime", tapeRecoveryPointTime)
    def getTapeSizeInBytes: ZIO[Any, AwsError, TapeSize] =
      AwsError.unwrapOptionField("tapeSizeInBytes", tapeSizeInBytes)
    def getTapeStatus: ZIO[Any, AwsError, TapeRecoveryPointStatus] =
      AwsError.unwrapOptionField("tapeStatus", tapeStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo
  ) extends zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly {
    override val tapeARN: Option[TapeARN] = scala
      .Option(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
    override val tapeRecoveryPointTime: Option[Time] = scala
      .Option(impl.tapeRecoveryPointTime())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val tapeSizeInBytes: Option[TapeSize] = scala
      .Option(impl.tapeSizeInBytes())
      .map(value => zio.aws.storagegateway.model.primitives.TapeSize(value))
    override val tapeStatus: Option[TapeRecoveryPointStatus] = scala
      .Option(impl.tapeStatus())
      .map(value =>
        zio.aws.storagegateway.model.primitives.TapeRecoveryPointStatus(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo
  ): zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly = new Wrapper(
    impl
  )
}
