package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileSystemAssociationARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateFileSystemResponse(
    fileSystemAssociationARN: Option[FileSystemAssociationARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse = {
    import AssociateFileSystemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse
      .builder()
      .optionallyWith(
        fileSystemAssociationARN.map(value =>
          FileSystemAssociationARN.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly =
    zio.aws.storagegateway.model.AssociateFileSystemResponse
      .wrap(buildAwsValue())
}
object AssociateFileSystemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AssociateFileSystemResponse =
      zio.aws.storagegateway.model.AssociateFileSystemResponse(
        fileSystemAssociationARN.map(value => value)
      )
    def fileSystemAssociationARN: Option[FileSystemAssociationARN]
    def getFileSystemAssociationARN
        : ZIO[Any, AwsError, FileSystemAssociationARN] = AwsError
      .unwrapOptionField("fileSystemAssociationARN", fileSystemAssociationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse
  ) extends zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly {
    override val fileSystemAssociationARN: Option[FileSystemAssociationARN] =
      scala
        .Option(impl.fileSystemAssociationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives
            .FileSystemAssociationARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse
  ): zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly =
    new Wrapper(impl)
}
