package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{GatewayARN, TapeARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RetrieveTapeArchiveRequest(
    tapeARN: TapeARN,
    gatewayARN: GatewayARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveRequest = {
    import RetrieveTapeArchiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveRequest
      .builder()
      .tapeARN(TapeARN.unwrap(tapeARN): java.lang.String)
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.RetrieveTapeArchiveRequest.ReadOnly =
    zio.aws.storagegateway.model.RetrieveTapeArchiveRequest
      .wrap(buildAwsValue())
}
object RetrieveTapeArchiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.RetrieveTapeArchiveRequest =
      zio.aws.storagegateway.model
        .RetrieveTapeArchiveRequest(tapeARN, gatewayARN)
    def tapeARN: TapeARN
    def gatewayARN: GatewayARN
    def getTapeARN: ZIO[Any, Nothing, TapeARN] = ZIO.succeed(tapeARN)
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveRequest
  ) extends zio.aws.storagegateway.model.RetrieveTapeArchiveRequest.ReadOnly {
    override val tapeARN: TapeARN =
      zio.aws.storagegateway.model.primitives.TapeARN(impl.tapeARN())
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveRequest
  ): zio.aws.storagegateway.model.RetrieveTapeArchiveRequest.ReadOnly =
    new Wrapper(impl)
}
