package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  VTLDeviceProductIdentifier,
  VTLDeviceVendor,
  VTLDeviceType,
  VTLDeviceARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VTLDevice(
    vtlDeviceARN: Option[VTLDeviceARN] = None,
    vtlDeviceType: Option[VTLDeviceType] = None,
    vtlDeviceVendor: Option[VTLDeviceVendor] = None,
    vtlDeviceProductIdentifier: Option[VTLDeviceProductIdentifier] = None,
    deviceiSCSIAttributes: Option[
      zio.aws.storagegateway.model.DeviceiSCSIAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.VTLDevice = {
    import VTLDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.VTLDevice
      .builder()
      .optionallyWith(
        vtlDeviceARN.map(value => VTLDeviceARN.unwrap(value): java.lang.String)
      )(_.vtlDeviceARN)
      .optionallyWith(
        vtlDeviceType.map(value =>
          VTLDeviceType.unwrap(value): java.lang.String
        )
      )(_.vtlDeviceType)
      .optionallyWith(
        vtlDeviceVendor.map(value =>
          VTLDeviceVendor.unwrap(value): java.lang.String
        )
      )(_.vtlDeviceVendor)
      .optionallyWith(
        vtlDeviceProductIdentifier.map(value =>
          VTLDeviceProductIdentifier.unwrap(value): java.lang.String
        )
      )(_.vtlDeviceProductIdentifier)
      .optionallyWith(
        deviceiSCSIAttributes.map(value => value.buildAwsValue())
      )(_.deviceiSCSIAttributes)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.VTLDevice.ReadOnly =
    zio.aws.storagegateway.model.VTLDevice.wrap(buildAwsValue())
}
object VTLDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.VTLDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.VTLDevice =
      zio.aws.storagegateway.model.VTLDevice(
        vtlDeviceARN.map(value => value),
        vtlDeviceType.map(value => value),
        vtlDeviceVendor.map(value => value),
        vtlDeviceProductIdentifier.map(value => value),
        deviceiSCSIAttributes.map(value => value.asEditable)
      )
    def vtlDeviceARN: Option[VTLDeviceARN]
    def vtlDeviceType: Option[VTLDeviceType]
    def vtlDeviceVendor: Option[VTLDeviceVendor]
    def vtlDeviceProductIdentifier: Option[VTLDeviceProductIdentifier]
    def deviceiSCSIAttributes
        : Option[zio.aws.storagegateway.model.DeviceiSCSIAttributes.ReadOnly]
    def getVtlDeviceARN: ZIO[Any, AwsError, VTLDeviceARN] =
      AwsError.unwrapOptionField("vtlDeviceARN", vtlDeviceARN)
    def getVtlDeviceType: ZIO[Any, AwsError, VTLDeviceType] =
      AwsError.unwrapOptionField("vtlDeviceType", vtlDeviceType)
    def getVtlDeviceVendor: ZIO[Any, AwsError, VTLDeviceVendor] =
      AwsError.unwrapOptionField("vtlDeviceVendor", vtlDeviceVendor)
    def getVtlDeviceProductIdentifier
        : ZIO[Any, AwsError, VTLDeviceProductIdentifier] =
      AwsError.unwrapOptionField(
        "vtlDeviceProductIdentifier",
        vtlDeviceProductIdentifier
      )
    def getDeviceiSCSIAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.DeviceiSCSIAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("deviceiSCSIAttributes", deviceiSCSIAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.VTLDevice
  ) extends zio.aws.storagegateway.model.VTLDevice.ReadOnly {
    override val vtlDeviceARN: Option[VTLDeviceARN] = scala
      .Option(impl.vtlDeviceARN())
      .map(value => zio.aws.storagegateway.model.primitives.VTLDeviceARN(value))
    override val vtlDeviceType: Option[VTLDeviceType] = scala
      .Option(impl.vtlDeviceType())
      .map(value =>
        zio.aws.storagegateway.model.primitives.VTLDeviceType(value)
      )
    override val vtlDeviceVendor: Option[VTLDeviceVendor] = scala
      .Option(impl.vtlDeviceVendor())
      .map(value =>
        zio.aws.storagegateway.model.primitives.VTLDeviceVendor(value)
      )
    override val vtlDeviceProductIdentifier
        : Option[VTLDeviceProductIdentifier] = scala
      .Option(impl.vtlDeviceProductIdentifier())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .VTLDeviceProductIdentifier(value)
      )
    override val deviceiSCSIAttributes
        : Option[zio.aws.storagegateway.model.DeviceiSCSIAttributes.ReadOnly] =
      scala
        .Option(impl.deviceiSCSIAttributes())
        .map(value =>
          zio.aws.storagegateway.model.DeviceiSCSIAttributes.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.VTLDevice
  ): zio.aws.storagegateway.model.VTLDevice.ReadOnly = new Wrapper(impl)
}
