package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.PoolARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteTapePoolResponse(poolARN: Option[PoolARN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse = {
    import DeleteTapePoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse
      .builder()
      .optionallyWith(
        poolARN.map(value => PoolARN.unwrap(value): java.lang.String)
      )(_.poolARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly =
    zio.aws.storagegateway.model.DeleteTapePoolResponse.wrap(buildAwsValue())
}
object DeleteTapePoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteTapePoolResponse =
      zio.aws.storagegateway.model
        .DeleteTapePoolResponse(poolARN.map(value => value))
    def poolARN: Option[PoolARN]
    def getPoolARN: ZIO[Any, AwsError, PoolARN] =
      AwsError.unwrapOptionField("poolARN", poolARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse
  ) extends zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly {
    override val poolARN: Option[PoolARN] = scala
      .Option(impl.poolARN())
      .map(value => zio.aws.storagegateway.model.primitives.PoolARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse
  ): zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly = new Wrapper(
    impl
  )
}
