package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.TapeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssignTapePoolResponse(tapeARN: Option[TapeARN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AssignTapePoolResponse = {
    import AssignTapePoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AssignTapePoolResponse
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.AssignTapePoolResponse.ReadOnly =
    zio.aws.storagegateway.model.AssignTapePoolResponse.wrap(buildAwsValue())
}
object AssignTapePoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AssignTapePoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AssignTapePoolResponse =
      zio.aws.storagegateway.model
        .AssignTapePoolResponse(tapeARN.map(value => value))
    def tapeARN: Option[TapeARN]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AssignTapePoolResponse
  ) extends zio.aws.storagegateway.model.AssignTapePoolResponse.ReadOnly {
    override val tapeARN: Option[TapeARN] = scala
      .Option(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AssignTapePoolResponse
  ): zio.aws.storagegateway.model.AssignTapePoolResponse.ReadOnly = new Wrapper(
    impl
  )
}
