package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileShareARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NotifyWhenUploadedRequest(fileShareARN: FileShareARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedRequest = {
    import NotifyWhenUploadedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedRequest
      .builder()
      .fileShareARN(FileShareARN.unwrap(fileShareARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.NotifyWhenUploadedRequest.ReadOnly =
    zio.aws.storagegateway.model.NotifyWhenUploadedRequest.wrap(buildAwsValue())
}
object NotifyWhenUploadedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.NotifyWhenUploadedRequest =
      zio.aws.storagegateway.model.NotifyWhenUploadedRequest(fileShareARN)
    def fileShareARN: FileShareARN
    def getFileShareARN: ZIO[Any, Nothing, FileShareARN] =
      ZIO.succeed(fileShareARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedRequest
  ) extends zio.aws.storagegateway.model.NotifyWhenUploadedRequest.ReadOnly {
    override val fileShareARN: FileShareARN =
      zio.aws.storagegateway.model.primitives.FileShareARN(impl.fileShareARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedRequest
  ): zio.aws.storagegateway.model.NotifyWhenUploadedRequest.ReadOnly =
    new Wrapper(impl)
}
