package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  Description,
  RecurrenceInHours,
  HourOfDay,
  VolumeARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSnapshotScheduleRequest(
    volumeARN: VolumeARN,
    startAt: HourOfDay,
    recurrenceInHours: RecurrenceInHours,
    description: Option[Description] = None,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleRequest = {
    import UpdateSnapshotScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleRequest
      .builder()
      .volumeARN(VolumeARN.unwrap(volumeARN): java.lang.String)
      .startAt(HourOfDay.unwrap(startAt): Integer)
      .recurrenceInHours(RecurrenceInHours.unwrap(recurrenceInHours): Integer)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest
      .wrap(buildAwsValue())
}
object UpdateSnapshotScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest =
      zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest(
        volumeARN,
        startAt,
        recurrenceInHours,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeARN: VolumeARN
    def startAt: HourOfDay
    def recurrenceInHours: RecurrenceInHours
    def description: Option[Description]
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getVolumeARN: ZIO[Any, Nothing, VolumeARN] = ZIO.succeed(volumeARN)
    def getStartAt: ZIO[Any, Nothing, HourOfDay] = ZIO.succeed(startAt)
    def getRecurrenceInHours: ZIO[Any, Nothing, RecurrenceInHours] =
      ZIO.succeed(recurrenceInHours)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleRequest
  ) extends zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest.ReadOnly {
    override val volumeARN: VolumeARN =
      zio.aws.storagegateway.model.primitives.VolumeARN(impl.volumeARN())
    override val startAt: HourOfDay =
      zio.aws.storagegateway.model.primitives.HourOfDay(impl.startAt())
    override val recurrenceInHours: RecurrenceInHours =
      zio.aws.storagegateway.model.primitives
        .RecurrenceInHours(impl.recurrenceInHours())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.storagegateway.model.primitives.Description(value))
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleRequest
  ): zio.aws.storagegateway.model.UpdateSnapshotScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
