package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  StorageClass,
  UserListUser,
  KMSKey,
  AuditDestinationARN,
  FileShareName,
  FileShareId,
  FileShareARN,
  DNSHostName,
  RegionId,
  FileShareStatus,
  GatewayARN,
  LocationARN,
  Path,
  NotificationPolicy,
  Role,
  Authentication
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SMBFileShareInfo(
    fileShareARN: Option[FileShareARN] = None,
    fileShareId: Option[FileShareId] = None,
    fileShareStatus: Option[FileShareStatus] = None,
    gatewayARN: Option[GatewayARN] = None,
    kmsEncrypted: Option[Boolean] = None,
    kmsKey: Option[KMSKey] = None,
    path: Option[Path] = None,
    role: Option[Role] = None,
    locationARN: Option[LocationARN] = None,
    defaultStorageClass: Option[StorageClass] = None,
    objectACL: Option[zio.aws.storagegateway.model.ObjectACL] = None,
    readOnly: Option[Boolean] = None,
    guessMIMETypeEnabled: Option[Boolean] = None,
    requesterPays: Option[Boolean] = None,
    smbaclEnabled: Option[Boolean] = None,
    accessBasedEnumeration: Option[Boolean] = None,
    adminUserList: Option[Iterable[UserListUser]] = None,
    validUserList: Option[Iterable[UserListUser]] = None,
    invalidUserList: Option[Iterable[UserListUser]] = None,
    auditDestinationARN: Option[AuditDestinationARN] = None,
    authentication: Option[Authentication] = None,
    caseSensitivity: Option[zio.aws.storagegateway.model.CaseSensitivity] =
      None,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None,
    fileShareName: Option[FileShareName] = None,
    cacheAttributes: Option[zio.aws.storagegateway.model.CacheAttributes] =
      None,
    notificationPolicy: Option[NotificationPolicy] = None,
    vpcEndpointDNSName: Option[DNSHostName] = None,
    bucketRegion: Option[RegionId] = None,
    oplocksEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo = {
    import SMBFileShareInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo
      .builder()
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .optionallyWith(
        fileShareId.map(value => FileShareId.unwrap(value): java.lang.String)
      )(_.fileShareId)
      .optionallyWith(
        fileShareStatus.map(value =>
          FileShareStatus.unwrap(value): java.lang.String
        )
      )(_.fileShareStatus)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        locationARN.map(value => LocationARN.unwrap(value): java.lang.String)
      )(_.locationARN)
      .optionallyWith(
        defaultStorageClass.map(value =>
          StorageClass.unwrap(value): java.lang.String
        )
      )(_.defaultStorageClass)
      .optionallyWith(objectACL.map(value => value.unwrap))(_.objectACL)
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        guessMIMETypeEnabled.map(value => value: java.lang.Boolean)
      )(_.guessMIMETypeEnabled)
      .optionallyWith(requesterPays.map(value => value: java.lang.Boolean))(
        _.requesterPays
      )
      .optionallyWith(smbaclEnabled.map(value => value: java.lang.Boolean))(
        _.smbaclEnabled
      )
      .optionallyWith(
        accessBasedEnumeration.map(value => value: java.lang.Boolean)
      )(_.accessBasedEnumeration)
      .optionallyWith(
        adminUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.adminUserList)
      .optionallyWith(
        validUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.validUserList)
      .optionallyWith(
        invalidUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.invalidUserList)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .optionallyWith(
        authentication.map(value =>
          Authentication.unwrap(value): java.lang.String
        )
      )(_.authentication)
      .optionallyWith(caseSensitivity.map(value => value.unwrap))(
        _.caseSensitivity
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        fileShareName.map(value =>
          FileShareName.unwrap(value): java.lang.String
        )
      )(_.fileShareName)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .optionallyWith(
        notificationPolicy.map(value =>
          NotificationPolicy.unwrap(value): java.lang.String
        )
      )(_.notificationPolicy)
      .optionallyWith(
        vpcEndpointDNSName.map(value =>
          DNSHostName.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointDNSName)
      .optionallyWith(
        bucketRegion.map(value => RegionId.unwrap(value): java.lang.String)
      )(_.bucketRegion)
      .optionallyWith(oplocksEnabled.map(value => value: java.lang.Boolean))(
        _.oplocksEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly =
    zio.aws.storagegateway.model.SMBFileShareInfo.wrap(buildAwsValue())
}
object SMBFileShareInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.SMBFileShareInfo =
      zio.aws.storagegateway.model.SMBFileShareInfo(
        fileShareARN.map(value => value),
        fileShareId.map(value => value),
        fileShareStatus.map(value => value),
        gatewayARN.map(value => value),
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        path.map(value => value),
        role.map(value => value),
        locationARN.map(value => value),
        defaultStorageClass.map(value => value),
        objectACL.map(value => value),
        readOnly.map(value => value),
        guessMIMETypeEnabled.map(value => value),
        requesterPays.map(value => value),
        smbaclEnabled.map(value => value),
        accessBasedEnumeration.map(value => value),
        adminUserList.map(value => value),
        validUserList.map(value => value),
        invalidUserList.map(value => value),
        auditDestinationARN.map(value => value),
        authentication.map(value => value),
        caseSensitivity.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileShareName.map(value => value),
        cacheAttributes.map(value => value.asEditable),
        notificationPolicy.map(value => value),
        vpcEndpointDNSName.map(value => value),
        bucketRegion.map(value => value),
        oplocksEnabled.map(value => value)
      )
    def fileShareARN: Option[FileShareARN]
    def fileShareId: Option[FileShareId]
    def fileShareStatus: Option[FileShareStatus]
    def gatewayARN: Option[GatewayARN]
    def kmsEncrypted: Option[Boolean]
    def kmsKey: Option[KMSKey]
    def path: Option[Path]
    def role: Option[Role]
    def locationARN: Option[LocationARN]
    def defaultStorageClass: Option[StorageClass]
    def objectACL: Option[zio.aws.storagegateway.model.ObjectACL]
    def readOnly: Option[Boolean]
    def guessMIMETypeEnabled: Option[Boolean]
    def requesterPays: Option[Boolean]
    def smbaclEnabled: Option[Boolean]
    def accessBasedEnumeration: Option[Boolean]
    def adminUserList: Option[List[UserListUser]]
    def validUserList: Option[List[UserListUser]]
    def invalidUserList: Option[List[UserListUser]]
    def auditDestinationARN: Option[AuditDestinationARN]
    def authentication: Option[Authentication]
    def caseSensitivity: Option[zio.aws.storagegateway.model.CaseSensitivity]
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def fileShareName: Option[FileShareName]
    def cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def notificationPolicy: Option[NotificationPolicy]
    def vpcEndpointDNSName: Option[DNSHostName]
    def bucketRegion: Option[RegionId]
    def oplocksEnabled: Option[Boolean]
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
    def getFileShareId: ZIO[Any, AwsError, FileShareId] =
      AwsError.unwrapOptionField("fileShareId", fileShareId)
    def getFileShareStatus: ZIO[Any, AwsError, FileShareStatus] =
      AwsError.unwrapOptionField("fileShareStatus", fileShareStatus)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getLocationARN: ZIO[Any, AwsError, LocationARN] =
      AwsError.unwrapOptionField("locationARN", locationARN)
    def getDefaultStorageClass: ZIO[Any, AwsError, StorageClass] =
      AwsError.unwrapOptionField("defaultStorageClass", defaultStorageClass)
    def getObjectACL
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.ObjectACL] =
      AwsError.unwrapOptionField("objectACL", objectACL)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getGuessMIMETypeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("guessMIMETypeEnabled", guessMIMETypeEnabled)
    def getRequesterPays: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterPays", requesterPays)
    def getSmbaclEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("smbaclEnabled", smbaclEnabled)
    def getAccessBasedEnumeration: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("accessBasedEnumeration", accessBasedEnumeration)
    def getAdminUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("adminUserList", adminUserList)
    def getValidUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("validUserList", validUserList)
    def getInvalidUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("invalidUserList", invalidUserList)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
    def getAuthentication: ZIO[Any, AwsError, Authentication] =
      AwsError.unwrapOptionField("authentication", authentication)
    def getCaseSensitivity
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.CaseSensitivity] =
      AwsError.unwrapOptionField("caseSensitivity", caseSensitivity)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileShareName: ZIO[Any, AwsError, FileShareName] =
      AwsError.unwrapOptionField("fileShareName", fileShareName)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
    def getNotificationPolicy: ZIO[Any, AwsError, NotificationPolicy] =
      AwsError.unwrapOptionField("notificationPolicy", notificationPolicy)
    def getVpcEndpointDNSName: ZIO[Any, AwsError, DNSHostName] =
      AwsError.unwrapOptionField("vpcEndpointDNSName", vpcEndpointDNSName)
    def getBucketRegion: ZIO[Any, AwsError, RegionId] =
      AwsError.unwrapOptionField("bucketRegion", bucketRegion)
    def getOplocksEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("oplocksEnabled", oplocksEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo
  ) extends zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly {
    override val fileShareARN: Option[FileShareARN] = scala
      .Option(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
    override val fileShareId: Option[FileShareId] = scala
      .Option(impl.fileShareId())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareId(value))
    override val fileShareStatus: Option[FileShareStatus] = scala
      .Option(impl.fileShareStatus())
      .map(value =>
        zio.aws.storagegateway.model.primitives.FileShareStatus(value)
      )
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val kmsEncrypted: Option[Boolean] =
      scala.Option(impl.kmsEncrypted()).map(value => value: Boolean)
    override val kmsKey: Option[KMSKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val path: Option[Path] = scala
      .Option(impl.path())
      .map(value => zio.aws.storagegateway.model.primitives.Path(value))
    override val role: Option[Role] = scala
      .Option(impl.role())
      .map(value => zio.aws.storagegateway.model.primitives.Role(value))
    override val locationARN: Option[LocationARN] = scala
      .Option(impl.locationARN())
      .map(value => zio.aws.storagegateway.model.primitives.LocationARN(value))
    override val defaultStorageClass: Option[StorageClass] = scala
      .Option(impl.defaultStorageClass())
      .map(value => zio.aws.storagegateway.model.primitives.StorageClass(value))
    override val objectACL: Option[zio.aws.storagegateway.model.ObjectACL] =
      scala
        .Option(impl.objectACL())
        .map(value => zio.aws.storagegateway.model.ObjectACL.wrap(value))
    override val readOnly: Option[Boolean] =
      scala.Option(impl.readOnly()).map(value => value: Boolean)
    override val guessMIMETypeEnabled: Option[Boolean] =
      scala.Option(impl.guessMIMETypeEnabled()).map(value => value: Boolean)
    override val requesterPays: Option[Boolean] =
      scala.Option(impl.requesterPays()).map(value => value: Boolean)
    override val smbaclEnabled: Option[Boolean] =
      scala.Option(impl.smbaclEnabled()).map(value => value: Boolean)
    override val accessBasedEnumeration: Option[Boolean] =
      scala.Option(impl.accessBasedEnumeration()).map(value => value: Boolean)
    override val adminUserList: Option[List[UserListUser]] = scala
      .Option(impl.adminUserList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.UserListUser(item)
        }.toList
      )
    override val validUserList: Option[List[UserListUser]] = scala
      .Option(impl.validUserList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.UserListUser(item)
        }.toList
      )
    override val invalidUserList: Option[List[UserListUser]] = scala
      .Option(impl.invalidUserList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.UserListUser(item)
        }.toList
      )
    override val auditDestinationARN: Option[AuditDestinationARN] = scala
      .Option(impl.auditDestinationARN())
      .map(value =>
        zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
      )
    override val authentication: Option[Authentication] = scala
      .Option(impl.authentication())
      .map(value =>
        zio.aws.storagegateway.model.primitives.Authentication(value)
      )
    override val caseSensitivity
        : Option[zio.aws.storagegateway.model.CaseSensitivity] = scala
      .Option(impl.caseSensitivity())
      .map(value => zio.aws.storagegateway.model.CaseSensitivity.wrap(value))
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
    override val fileShareName: Option[FileShareName] = scala
      .Option(impl.fileShareName())
      .map(value =>
        zio.aws.storagegateway.model.primitives.FileShareName(value)
      )
    override val cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] = scala
      .Option(impl.cacheAttributes())
      .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
    override val notificationPolicy: Option[NotificationPolicy] = scala
      .Option(impl.notificationPolicy())
      .map(value =>
        zio.aws.storagegateway.model.primitives.NotificationPolicy(value)
      )
    override val vpcEndpointDNSName: Option[DNSHostName] = scala
      .Option(impl.vpcEndpointDNSName())
      .map(value => zio.aws.storagegateway.model.primitives.DNSHostName(value))
    override val bucketRegion: Option[RegionId] = scala
      .Option(impl.bucketRegion())
      .map(value => zio.aws.storagegateway.model.primitives.RegionId(value))
    override val oplocksEnabled: Option[Boolean] =
      scala.Option(impl.oplocksEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo
  ): zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly = new Wrapper(impl)
}
