package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{SnapshotId, VolumeARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotResponse(
    volumeARN: Option[VolumeARN] = None,
    snapshotId: Option[SnapshotId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CreateSnapshotResponse.ReadOnly =
    zio.aws.storagegateway.model.CreateSnapshotResponse.wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateSnapshotResponse =
      zio.aws.storagegateway.model.CreateSnapshotResponse(
        volumeARN.map(value => value),
        snapshotId.map(value => value)
      )
    def volumeARN: Option[VolumeARN]
    def snapshotId: Option[SnapshotId]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSnapshotResponse
  ) extends zio.aws.storagegateway.model.CreateSnapshotResponse.ReadOnly {
    override val volumeARN: Option[VolumeARN] = scala
      .Option(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val snapshotId: Option[SnapshotId] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.storagegateway.model.primitives.SnapshotId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSnapshotResponse
  ): zio.aws.storagegateway.model.CreateSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
