package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  Marker,
  PositiveIntObject,
  GatewayARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFileSystemAssociationsRequest(
    gatewayARN: Option[GatewayARN] = None,
    limit: Option[PositiveIntObject] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest = {
    import ListFileSystemAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ListFileSystemAssociationsRequest.ReadOnly =
    zio.aws.storagegateway.model.ListFileSystemAssociationsRequest
      .wrap(buildAwsValue())
}
object ListFileSystemAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.ListFileSystemAssociationsRequest =
      zio.aws.storagegateway.model.ListFileSystemAssociationsRequest(
        gatewayARN.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def gatewayARN: Option[GatewayARN]
    def limit: Option[PositiveIntObject]
    def marker: Option[Marker]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest
  ) extends zio.aws.storagegateway.model.ListFileSystemAssociationsRequest.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val limit: Option[PositiveIntObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest
  ): zio.aws.storagegateway.model.ListFileSystemAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
