package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteGatewayRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteGatewayRequest = {
    import DeleteGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteGatewayRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DeleteGatewayRequest.ReadOnly =
    zio.aws.storagegateway.model.DeleteGatewayRequest.wrap(buildAwsValue())
}
object DeleteGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteGatewayRequest =
      zio.aws.storagegateway.model.DeleteGatewayRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteGatewayRequest
  ) extends zio.aws.storagegateway.model.DeleteGatewayRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteGatewayRequest
  ): zio.aws.storagegateway.model.DeleteGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
