package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  Ec2InstanceId,
  GatewayId,
  GatewayOperationalState,
  Ec2InstanceRegion,
  GatewayType,
  GatewayARN,
  HostEnvironmentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GatewayInfo(
    gatewayId: Option[GatewayId] = None,
    gatewayARN: Option[GatewayARN] = None,
    gatewayType: Option[GatewayType] = None,
    gatewayOperationalState: Option[GatewayOperationalState] = None,
    gatewayName: Option[String] = None,
    ec2InstanceId: Option[Ec2InstanceId] = None,
    ec2InstanceRegion: Option[Ec2InstanceRegion] = None,
    hostEnvironment: Option[zio.aws.storagegateway.model.HostEnvironment] =
      None,
    hostEnvironmentId: Option[HostEnvironmentId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.GatewayInfo = {
    import GatewayInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.GatewayInfo
      .builder()
      .optionallyWith(
        gatewayId.map(value => GatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        gatewayType.map(value => GatewayType.unwrap(value): java.lang.String)
      )(_.gatewayType)
      .optionallyWith(
        gatewayOperationalState.map(value =>
          GatewayOperationalState.unwrap(value): java.lang.String
        )
      )(_.gatewayOperationalState)
      .optionallyWith(gatewayName.map(value => value: java.lang.String))(
        _.gatewayName
      )
      .optionallyWith(
        ec2InstanceId.map(value =>
          Ec2InstanceId.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceId)
      .optionallyWith(
        ec2InstanceRegion.map(value =>
          Ec2InstanceRegion.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceRegion)
      .optionallyWith(hostEnvironment.map(value => value.unwrap))(
        _.hostEnvironment
      )
      .optionallyWith(
        hostEnvironmentId.map(value =>
          HostEnvironmentId.unwrap(value): java.lang.String
        )
      )(_.hostEnvironmentId)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.GatewayInfo.ReadOnly =
    zio.aws.storagegateway.model.GatewayInfo.wrap(buildAwsValue())
}
object GatewayInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.GatewayInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.GatewayInfo =
      zio.aws.storagegateway.model.GatewayInfo(
        gatewayId.map(value => value),
        gatewayARN.map(value => value),
        gatewayType.map(value => value),
        gatewayOperationalState.map(value => value),
        gatewayName.map(value => value),
        ec2InstanceId.map(value => value),
        ec2InstanceRegion.map(value => value),
        hostEnvironment.map(value => value),
        hostEnvironmentId.map(value => value)
      )
    def gatewayId: Option[GatewayId]
    def gatewayARN: Option[GatewayARN]
    def gatewayType: Option[GatewayType]
    def gatewayOperationalState: Option[GatewayOperationalState]
    def gatewayName: Option[String]
    def ec2InstanceId: Option[Ec2InstanceId]
    def ec2InstanceRegion: Option[Ec2InstanceRegion]
    def hostEnvironment: Option[zio.aws.storagegateway.model.HostEnvironment]
    def hostEnvironmentId: Option[HostEnvironmentId]
    def getGatewayId: ZIO[Any, AwsError, GatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getGatewayType: ZIO[Any, AwsError, GatewayType] =
      AwsError.unwrapOptionField("gatewayType", gatewayType)
    def getGatewayOperationalState
        : ZIO[Any, AwsError, GatewayOperationalState] = AwsError
      .unwrapOptionField("gatewayOperationalState", gatewayOperationalState)
    def getGatewayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayName", gatewayName)
    def getEc2InstanceId: ZIO[Any, AwsError, Ec2InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getEc2InstanceRegion: ZIO[Any, AwsError, Ec2InstanceRegion] =
      AwsError.unwrapOptionField("ec2InstanceRegion", ec2InstanceRegion)
    def getHostEnvironment
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.HostEnvironment] =
      AwsError.unwrapOptionField("hostEnvironment", hostEnvironment)
    def getHostEnvironmentId: ZIO[Any, AwsError, HostEnvironmentId] =
      AwsError.unwrapOptionField("hostEnvironmentId", hostEnvironmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.GatewayInfo
  ) extends zio.aws.storagegateway.model.GatewayInfo.ReadOnly {
    override val gatewayId: Option[GatewayId] = scala
      .Option(impl.gatewayId())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayId(value))
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val gatewayType: Option[GatewayType] = scala
      .Option(impl.gatewayType())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayType(value))
    override val gatewayOperationalState: Option[GatewayOperationalState] =
      scala
        .Option(impl.gatewayOperationalState())
        .map(value =>
          zio.aws.storagegateway.model.primitives.GatewayOperationalState(value)
        )
    override val gatewayName: Option[String] =
      scala.Option(impl.gatewayName()).map(value => value: String)
    override val ec2InstanceId: Option[Ec2InstanceId] = scala
      .Option(impl.ec2InstanceId())
      .map(value =>
        zio.aws.storagegateway.model.primitives.Ec2InstanceId(value)
      )
    override val ec2InstanceRegion: Option[Ec2InstanceRegion] = scala
      .Option(impl.ec2InstanceRegion())
      .map(value =>
        zio.aws.storagegateway.model.primitives.Ec2InstanceRegion(value)
      )
    override val hostEnvironment
        : Option[zio.aws.storagegateway.model.HostEnvironment] = scala
      .Option(impl.hostEnvironment())
      .map(value => zio.aws.storagegateway.model.HostEnvironment.wrap(value))
    override val hostEnvironmentId: Option[HostEnvironmentId] = scala
      .Option(impl.hostEnvironmentId())
      .map(value =>
        zio.aws.storagegateway.model.primitives.HostEnvironmentId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.GatewayInfo
  ): zio.aws.storagegateway.model.GatewayInfo.ReadOnly = new Wrapper(impl)
}
