package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{IqnName, ChapSecret, TargetARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChapInfo(
    targetARN: Option[TargetARN] = None,
    secretToAuthenticateInitiator: Option[ChapSecret] = None,
    initiatorName: Option[IqnName] = None,
    secretToAuthenticateTarget: Option[ChapSecret] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ChapInfo = {
    import ChapInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ChapInfo
      .builder()
      .optionallyWith(
        targetARN.map(value => TargetARN.unwrap(value): java.lang.String)
      )(_.targetARN)
      .optionallyWith(
        secretToAuthenticateInitiator.map(value =>
          ChapSecret.unwrap(value): java.lang.String
        )
      )(_.secretToAuthenticateInitiator)
      .optionallyWith(
        initiatorName.map(value => IqnName.unwrap(value): java.lang.String)
      )(_.initiatorName)
      .optionallyWith(
        secretToAuthenticateTarget.map(value =>
          ChapSecret.unwrap(value): java.lang.String
        )
      )(_.secretToAuthenticateTarget)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ChapInfo.ReadOnly =
    zio.aws.storagegateway.model.ChapInfo.wrap(buildAwsValue())
}
object ChapInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ChapInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ChapInfo =
      zio.aws.storagegateway.model.ChapInfo(
        targetARN.map(value => value),
        secretToAuthenticateInitiator.map(value => value),
        initiatorName.map(value => value),
        secretToAuthenticateTarget.map(value => value)
      )
    def targetARN: Option[TargetARN]
    def secretToAuthenticateInitiator: Option[ChapSecret]
    def initiatorName: Option[IqnName]
    def secretToAuthenticateTarget: Option[ChapSecret]
    def getTargetARN: ZIO[Any, AwsError, TargetARN] =
      AwsError.unwrapOptionField("targetARN", targetARN)
    def getSecretToAuthenticateInitiator: ZIO[Any, AwsError, ChapSecret] =
      AwsError.unwrapOptionField(
        "secretToAuthenticateInitiator",
        secretToAuthenticateInitiator
      )
    def getInitiatorName: ZIO[Any, AwsError, IqnName] =
      AwsError.unwrapOptionField("initiatorName", initiatorName)
    def getSecretToAuthenticateTarget: ZIO[Any, AwsError, ChapSecret] =
      AwsError.unwrapOptionField(
        "secretToAuthenticateTarget",
        secretToAuthenticateTarget
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ChapInfo
  ) extends zio.aws.storagegateway.model.ChapInfo.ReadOnly {
    override val targetARN: Option[TargetARN] = scala
      .Option(impl.targetARN())
      .map(value => zio.aws.storagegateway.model.primitives.TargetARN(value))
    override val secretToAuthenticateInitiator: Option[ChapSecret] = scala
      .Option(impl.secretToAuthenticateInitiator())
      .map(value => zio.aws.storagegateway.model.primitives.ChapSecret(value))
    override val initiatorName: Option[IqnName] = scala
      .Option(impl.initiatorName())
      .map(value => zio.aws.storagegateway.model.primitives.IqnName(value))
    override val secretToAuthenticateTarget: Option[ChapSecret] = scala
      .Option(impl.secretToAuthenticateTarget())
      .map(value => zio.aws.storagegateway.model.primitives.ChapSecret(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ChapInfo
  ): zio.aws.storagegateway.model.ChapInfo.ReadOnly = new Wrapper(impl)
}
