package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{TapeARN, GatewayARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelRetrievalRequest(
    gatewayARN: GatewayARN,
    tapeARN: TapeARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CancelRetrievalRequest = {
    import CancelRetrievalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CancelRetrievalRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .tapeARN(TapeARN.unwrap(tapeARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CancelRetrievalRequest.ReadOnly =
    zio.aws.storagegateway.model.CancelRetrievalRequest.wrap(buildAwsValue())
}
object CancelRetrievalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CancelRetrievalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CancelRetrievalRequest =
      zio.aws.storagegateway.model.CancelRetrievalRequest(gatewayARN, tapeARN)
    def gatewayARN: GatewayARN
    def tapeARN: TapeARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getTapeARN: ZIO[Any, Nothing, TapeARN] = ZIO.succeed(tapeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CancelRetrievalRequest
  ) extends zio.aws.storagegateway.model.CancelRetrievalRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val tapeARN: TapeARN =
      zio.aws.storagegateway.model.primitives.TapeARN(impl.tapeARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CancelRetrievalRequest
  ): zio.aws.storagegateway.model.CancelRetrievalRequest.ReadOnly = new Wrapper(
    impl
  )
}
