package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  LocalConsolePassword,
  GatewayARN
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetLocalConsolePasswordRequest(
    gatewayARN: GatewayARN,
    localConsolePassword: LocalConsolePassword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordRequest = {
    import SetLocalConsolePasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .localConsolePassword(
        LocalConsolePassword.unwrap(localConsolePassword): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.SetLocalConsolePasswordRequest.ReadOnly =
    zio.aws.storagegateway.model.SetLocalConsolePasswordRequest
      .wrap(buildAwsValue())
}
object SetLocalConsolePasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.SetLocalConsolePasswordRequest =
      zio.aws.storagegateway.model
        .SetLocalConsolePasswordRequest(gatewayARN, localConsolePassword)
    def gatewayARN: GatewayARN
    def localConsolePassword: LocalConsolePassword
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getLocalConsolePassword: ZIO[Any, Nothing, LocalConsolePassword] =
      ZIO.succeed(localConsolePassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordRequest
  ) extends zio.aws.storagegateway.model.SetLocalConsolePasswordRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val localConsolePassword: LocalConsolePassword =
      zio.aws.storagegateway.model.primitives
        .LocalConsolePassword(impl.localConsolePassword())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordRequest
  ): zio.aws.storagegateway.model.SetLocalConsolePasswordRequest.ReadOnly =
    new Wrapper(impl)
}
